@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.SecuritySettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The SecuritySettings of AzureStackHCI Cluster.
 * @property bitlockerBootVolume When set to true, BitLocker XTS_AES 256-bit encryption is enabled for all data-at-rest on the OS volume of your Azure Stack HCI cluster. This setting is TPM-hardware dependent.
 * @property bitlockerDataVolumes When set to true, BitLocker XTS-AES 256-bit encryption is enabled for all data-at-rest on your Azure Stack HCI cluster shared volumes.
 * @property credentialGuardEnforced When set to true, Credential Guard is enabled.
 * @property driftControlEnforced When set to true, the security baseline is re-applied regularly.
 * @property drtmProtection By default, Secure Boot is enabled on your Azure HCI cluster. This setting is hardware dependent.
 * @property hvciProtection By default, Hypervisor-protected Code Integrity is enabled on your Azure HCI cluster.
 * @property sideChannelMitigationEnforced When set to true, all the side channel mitigations are enabled
 * @property smbClusterEncryption When set to true, cluster east-west traffic is encrypted.
 * @property smbSigningEnforced When set to true, the SMB default instance requires sign in for the client and server services.
 * @property wdacEnforced WDAC is enabled by default and limits the applications and the code that you can run on your Azure Stack HCI cluster.
 */
public data class SecuritySettingsArgs(
    public val bitlockerBootVolume: Output<Boolean>? = null,
    public val bitlockerDataVolumes: Output<Boolean>? = null,
    public val credentialGuardEnforced: Output<Boolean>? = null,
    public val driftControlEnforced: Output<Boolean>? = null,
    public val drtmProtection: Output<Boolean>? = null,
    public val hvciProtection: Output<Boolean>? = null,
    public val sideChannelMitigationEnforced: Output<Boolean>? = null,
    public val smbClusterEncryption: Output<Boolean>? = null,
    public val smbSigningEnforced: Output<Boolean>? = null,
    public val wdacEnforced: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.SecuritySettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.SecuritySettingsArgs =
        com.pulumi.azurenative.azurestackhci.inputs.SecuritySettingsArgs.builder()
            .bitlockerBootVolume(bitlockerBootVolume?.applyValue({ args0 -> args0 }))
            .bitlockerDataVolumes(bitlockerDataVolumes?.applyValue({ args0 -> args0 }))
            .credentialGuardEnforced(credentialGuardEnforced?.applyValue({ args0 -> args0 }))
            .driftControlEnforced(driftControlEnforced?.applyValue({ args0 -> args0 }))
            .drtmProtection(drtmProtection?.applyValue({ args0 -> args0 }))
            .hvciProtection(hvciProtection?.applyValue({ args0 -> args0 }))
            .sideChannelMitigationEnforced(sideChannelMitigationEnforced?.applyValue({ args0 -> args0 }))
            .smbClusterEncryption(smbClusterEncryption?.applyValue({ args0 -> args0 }))
            .smbSigningEnforced(smbSigningEnforced?.applyValue({ args0 -> args0 }))
            .wdacEnforced(wdacEnforced?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecuritySettingsArgs].
 */
@PulumiTagMarker
public class SecuritySettingsArgsBuilder internal constructor() {
    private var bitlockerBootVolume: Output<Boolean>? = null

    private var bitlockerDataVolumes: Output<Boolean>? = null

    private var credentialGuardEnforced: Output<Boolean>? = null

    private var driftControlEnforced: Output<Boolean>? = null

    private var drtmProtection: Output<Boolean>? = null

    private var hvciProtection: Output<Boolean>? = null

    private var sideChannelMitigationEnforced: Output<Boolean>? = null

    private var smbClusterEncryption: Output<Boolean>? = null

    private var smbSigningEnforced: Output<Boolean>? = null

    private var wdacEnforced: Output<Boolean>? = null

    /**
     * @param value When set to true, BitLocker XTS_AES 256-bit encryption is enabled for all data-at-rest on the OS volume of your Azure Stack HCI cluster. This setting is TPM-hardware dependent.
     */
    @JvmName("ekkaishrvdpooqwb")
    public suspend fun bitlockerBootVolume(`value`: Output<Boolean>) {
        this.bitlockerBootVolume = value
    }

    /**
     * @param value When set to true, BitLocker XTS-AES 256-bit encryption is enabled for all data-at-rest on your Azure Stack HCI cluster shared volumes.
     */
    @JvmName("ilkrgrylrxmasppk")
    public suspend fun bitlockerDataVolumes(`value`: Output<Boolean>) {
        this.bitlockerDataVolumes = value
    }

    /**
     * @param value When set to true, Credential Guard is enabled.
     */
    @JvmName("xxliqnrhtwppdwir")
    public suspend fun credentialGuardEnforced(`value`: Output<Boolean>) {
        this.credentialGuardEnforced = value
    }

    /**
     * @param value When set to true, the security baseline is re-applied regularly.
     */
    @JvmName("hcrwucdkojvvohtm")
    public suspend fun driftControlEnforced(`value`: Output<Boolean>) {
        this.driftControlEnforced = value
    }

    /**
     * @param value By default, Secure Boot is enabled on your Azure HCI cluster. This setting is hardware dependent.
     */
    @JvmName("gvinxcjtovxwafgy")
    public suspend fun drtmProtection(`value`: Output<Boolean>) {
        this.drtmProtection = value
    }

    /**
     * @param value By default, Hypervisor-protected Code Integrity is enabled on your Azure HCI cluster.
     */
    @JvmName("jvbaiwpvugtshloi")
    public suspend fun hvciProtection(`value`: Output<Boolean>) {
        this.hvciProtection = value
    }

    /**
     * @param value When set to true, all the side channel mitigations are enabled
     */
    @JvmName("hqfrhwmpwukjyhmx")
    public suspend fun sideChannelMitigationEnforced(`value`: Output<Boolean>) {
        this.sideChannelMitigationEnforced = value
    }

    /**
     * @param value When set to true, cluster east-west traffic is encrypted.
     */
    @JvmName("xvdwngagyvubtptv")
    public suspend fun smbClusterEncryption(`value`: Output<Boolean>) {
        this.smbClusterEncryption = value
    }

    /**
     * @param value When set to true, the SMB default instance requires sign in for the client and server services.
     */
    @JvmName("iwsbueiwjdpanuxf")
    public suspend fun smbSigningEnforced(`value`: Output<Boolean>) {
        this.smbSigningEnforced = value
    }

    /**
     * @param value WDAC is enabled by default and limits the applications and the code that you can run on your Azure Stack HCI cluster.
     */
    @JvmName("qwkcxobglcicdmbj")
    public suspend fun wdacEnforced(`value`: Output<Boolean>) {
        this.wdacEnforced = value
    }

    /**
     * @param value When set to true, BitLocker XTS_AES 256-bit encryption is enabled for all data-at-rest on the OS volume of your Azure Stack HCI cluster. This setting is TPM-hardware dependent.
     */
    @JvmName("xagivygwadtorvap")
    public suspend fun bitlockerBootVolume(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bitlockerBootVolume = mapped
    }

    /**
     * @param value When set to true, BitLocker XTS-AES 256-bit encryption is enabled for all data-at-rest on your Azure Stack HCI cluster shared volumes.
     */
    @JvmName("ieypqevxbjkhyrwt")
    public suspend fun bitlockerDataVolumes(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bitlockerDataVolumes = mapped
    }

    /**
     * @param value When set to true, Credential Guard is enabled.
     */
    @JvmName("gxddpkeipesottfv")
    public suspend fun credentialGuardEnforced(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentialGuardEnforced = mapped
    }

    /**
     * @param value When set to true, the security baseline is re-applied regularly.
     */
    @JvmName("pcfkxsvdgeotdqps")
    public suspend fun driftControlEnforced(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.driftControlEnforced = mapped
    }

    /**
     * @param value By default, Secure Boot is enabled on your Azure HCI cluster. This setting is hardware dependent.
     */
    @JvmName("cmxljlovjptshpay")
    public suspend fun drtmProtection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.drtmProtection = mapped
    }

    /**
     * @param value By default, Hypervisor-protected Code Integrity is enabled on your Azure HCI cluster.
     */
    @JvmName("qhukghevhxyatvth")
    public suspend fun hvciProtection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hvciProtection = mapped
    }

    /**
     * @param value When set to true, all the side channel mitigations are enabled
     */
    @JvmName("xnboevukubqqmucm")
    public suspend fun sideChannelMitigationEnforced(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sideChannelMitigationEnforced = mapped
    }

    /**
     * @param value When set to true, cluster east-west traffic is encrypted.
     */
    @JvmName("ibpsmxshvjwwuokm")
    public suspend fun smbClusterEncryption(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.smbClusterEncryption = mapped
    }

    /**
     * @param value When set to true, the SMB default instance requires sign in for the client and server services.
     */
    @JvmName("tyhuqbgdibdsspry")
    public suspend fun smbSigningEnforced(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.smbSigningEnforced = mapped
    }

    /**
     * @param value WDAC is enabled by default and limits the applications and the code that you can run on your Azure Stack HCI cluster.
     */
    @JvmName("jkoimyxnjxxlwmew")
    public suspend fun wdacEnforced(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.wdacEnforced = mapped
    }

    internal fun build(): SecuritySettingsArgs = SecuritySettingsArgs(
        bitlockerBootVolume = bitlockerBootVolume,
        bitlockerDataVolumes = bitlockerDataVolumes,
        credentialGuardEnforced = credentialGuardEnforced,
        driftControlEnforced = driftControlEnforced,
        drtmProtection = drtmProtection,
        hvciProtection = hvciProtection,
        sideChannelMitigationEnforced = sideChannelMitigationEnforced,
        smbClusterEncryption = smbClusterEncryption,
        smbSigningEnforced = smbSigningEnforced,
        wdacEnforced = wdacEnforced,
    )
}
