@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.SubnetArgs.builder
import com.pulumi.azurenative.azurestackhci.kotlin.enums.IpAllocationMethodEnum
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property addressPrefix The address prefix for the subnet: Cidr for this subnet - IPv4, IPv6.
 * @property addressPrefixes List of address prefixes for the subnet.
 * @property ipAllocationMethod IPAllocationMethod - The IP address allocation method. Possible values include: 'Static', 'Dynamic'
 * @property ipConfigurationReferences IPConfigurationReferences - list of IPConfigurationReferences
 * @property ipPools network associated pool of IP Addresses
 * @property name Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property routeTable Route table resource.
 * @property vlan Vlan to use for the subnet
 */
public data class SubnetArgs(
    public val addressPrefix: Output<String>? = null,
    public val addressPrefixes: Output<List<String>>? = null,
    public val ipAllocationMethod: Output<Either<String, IpAllocationMethodEnum>>? = null,
    public val ipConfigurationReferences:
    Output<List<SubnetPropertiesFormatIpConfigurationReferencesArgs>>? = null,
    public val ipPools: Output<List<IPPoolArgs>>? = null,
    public val name: Output<String>? = null,
    public val routeTable: Output<RouteTableArgs>? = null,
    public val vlan: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.SubnetArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.SubnetArgs =
        com.pulumi.azurenative.azurestackhci.inputs.SubnetArgs.builder()
            .addressPrefix(addressPrefix?.applyValue({ args0 -> args0 }))
            .addressPrefixes(addressPrefixes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ipAllocationMethod(
                ipAllocationMethod?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .ipConfigurationReferences(
                ipConfigurationReferences?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .ipPools(
                ipPools?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .routeTable(routeTable?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vlan(vlan?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SubnetArgs].
 */
@PulumiTagMarker
public class SubnetArgsBuilder internal constructor() {
    private var addressPrefix: Output<String>? = null

    private var addressPrefixes: Output<List<String>>? = null

    private var ipAllocationMethod: Output<Either<String, IpAllocationMethodEnum>>? = null

    private var ipConfigurationReferences:
        Output<List<SubnetPropertiesFormatIpConfigurationReferencesArgs>>? = null

    private var ipPools: Output<List<IPPoolArgs>>? = null

    private var name: Output<String>? = null

    private var routeTable: Output<RouteTableArgs>? = null

    private var vlan: Output<Int>? = null

    /**
     * @param value The address prefix for the subnet: Cidr for this subnet - IPv4, IPv6.
     */
    @JvmName("scutoxwhpibrvfge")
    public suspend fun addressPrefix(`value`: Output<String>) {
        this.addressPrefix = value
    }

    /**
     * @param value List of address prefixes for the subnet.
     */
    @JvmName("esunheqmicdvypen")
    public suspend fun addressPrefixes(`value`: Output<List<String>>) {
        this.addressPrefixes = value
    }

    @JvmName("eslkyvgoowqfejas")
    public suspend fun addressPrefixes(vararg values: Output<String>) {
        this.addressPrefixes = Output.all(values.asList())
    }

    /**
     * @param values List of address prefixes for the subnet.
     */
    @JvmName("puenhrajtwmkcmqy")
    public suspend fun addressPrefixes(values: List<Output<String>>) {
        this.addressPrefixes = Output.all(values)
    }

    /**
     * @param value IPAllocationMethod - The IP address allocation method. Possible values include: 'Static', 'Dynamic'
     */
    @JvmName("kgxasemtvhdmxpte")
    public suspend fun ipAllocationMethod(`value`: Output<Either<String, IpAllocationMethodEnum>>) {
        this.ipAllocationMethod = value
    }

    /**
     * @param value IPConfigurationReferences - list of IPConfigurationReferences
     */
    @JvmName("ykqltopaonyncsar")
    public suspend
    fun ipConfigurationReferences(`value`: Output<List<SubnetPropertiesFormatIpConfigurationReferencesArgs>>) {
        this.ipConfigurationReferences = value
    }

    @JvmName("volfgirwyfiqbahi")
    public suspend fun ipConfigurationReferences(
        vararg
        values: Output<SubnetPropertiesFormatIpConfigurationReferencesArgs>,
    ) {
        this.ipConfigurationReferences = Output.all(values.asList())
    }

    /**
     * @param values IPConfigurationReferences - list of IPConfigurationReferences
     */
    @JvmName("bfkwnebmorpwetxk")
    public suspend
    fun ipConfigurationReferences(values: List<Output<SubnetPropertiesFormatIpConfigurationReferencesArgs>>) {
        this.ipConfigurationReferences = Output.all(values)
    }

    /**
     * @param value network associated pool of IP Addresses
     */
    @JvmName("hfaofoqrqdijstwu")
    public suspend fun ipPools(`value`: Output<List<IPPoolArgs>>) {
        this.ipPools = value
    }

    @JvmName("frdcvsoigjqrxgse")
    public suspend fun ipPools(vararg values: Output<IPPoolArgs>) {
        this.ipPools = Output.all(values.asList())
    }

    /**
     * @param values network associated pool of IP Addresses
     */
    @JvmName("efnwtrdlpfhfesei")
    public suspend fun ipPools(values: List<Output<IPPoolArgs>>) {
        this.ipPools = Output.all(values)
    }

    /**
     * @param value Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("ohdofvytnxxxcidp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Route table resource.
     */
    @JvmName("rvaodamxbpnnfsqb")
    public suspend fun routeTable(`value`: Output<RouteTableArgs>) {
        this.routeTable = value
    }

    /**
     * @param value Vlan to use for the subnet
     */
    @JvmName("tgxpuwduujrjmtcs")
    public suspend fun vlan(`value`: Output<Int>) {
        this.vlan = value
    }

    /**
     * @param value The address prefix for the subnet: Cidr for this subnet - IPv4, IPv6.
     */
    @JvmName("ctqyxvncvmdijirh")
    public suspend fun addressPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressPrefix = mapped
    }

    /**
     * @param value List of address prefixes for the subnet.
     */
    @JvmName("eymkyjxegccjfakb")
    public suspend fun addressPrefixes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressPrefixes = mapped
    }

    /**
     * @param values List of address prefixes for the subnet.
     */
    @JvmName("tcxygcssefbqkobr")
    public suspend fun addressPrefixes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addressPrefixes = mapped
    }

    /**
     * @param value IPAllocationMethod - The IP address allocation method. Possible values include: 'Static', 'Dynamic'
     */
    @JvmName("tpjnfrhfxhhupjse")
    public suspend fun ipAllocationMethod(`value`: Either<String, IpAllocationMethodEnum>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAllocationMethod = mapped
    }

    /**
     * @param value IPAllocationMethod - The IP address allocation method. Possible values include: 'Static', 'Dynamic'
     */
    @JvmName("jiqjtlqrpaiqfuco")
    public fun ipAllocationMethod(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IpAllocationMethodEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipAllocationMethod = mapped
    }

    /**
     * @param value IPAllocationMethod - The IP address allocation method. Possible values include: 'Static', 'Dynamic'
     */
    @JvmName("umbrcnedmjrgrsjt")
    public fun ipAllocationMethod(`value`: IpAllocationMethodEnum) {
        val toBeMapped = Either.ofRight<String, IpAllocationMethodEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipAllocationMethod = mapped
    }

    /**
     * @param value IPConfigurationReferences - list of IPConfigurationReferences
     */
    @JvmName("nivtcgklganwrkso")
    public suspend
    fun ipConfigurationReferences(`value`: List<SubnetPropertiesFormatIpConfigurationReferencesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipConfigurationReferences = mapped
    }

    /**
     * @param argument IPConfigurationReferences - list of IPConfigurationReferences
     */
    @JvmName("oujmrkpugmmhycfh")
    public suspend
    fun ipConfigurationReferences(argument: List<suspend SubnetPropertiesFormatIpConfigurationReferencesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SubnetPropertiesFormatIpConfigurationReferencesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ipConfigurationReferences = mapped
    }

    /**
     * @param argument IPConfigurationReferences - list of IPConfigurationReferences
     */
    @JvmName("xvmgeoetorekvxkm")
    public suspend fun ipConfigurationReferences(
        vararg
        argument: suspend SubnetPropertiesFormatIpConfigurationReferencesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SubnetPropertiesFormatIpConfigurationReferencesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ipConfigurationReferences = mapped
    }

    /**
     * @param argument IPConfigurationReferences - list of IPConfigurationReferences
     */
    @JvmName("vibbfmeeponmieib")
    public suspend
    fun ipConfigurationReferences(argument: suspend SubnetPropertiesFormatIpConfigurationReferencesArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                SubnetPropertiesFormatIpConfigurationReferencesArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.ipConfigurationReferences = mapped
    }

    /**
     * @param values IPConfigurationReferences - list of IPConfigurationReferences
     */
    @JvmName("eaohdqgdgygbghrj")
    public suspend fun ipConfigurationReferences(
        vararg
        values: SubnetPropertiesFormatIpConfigurationReferencesArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipConfigurationReferences = mapped
    }

    /**
     * @param value network associated pool of IP Addresses
     */
    @JvmName("lleovxunosscsuoi")
    public suspend fun ipPools(`value`: List<IPPoolArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipPools = mapped
    }

    /**
     * @param argument network associated pool of IP Addresses
     */
    @JvmName("mxalxtcenxiutpsq")
    public suspend fun ipPools(argument: List<suspend IPPoolArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { IPPoolArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipPools = mapped
    }

    /**
     * @param argument network associated pool of IP Addresses
     */
    @JvmName("kakmgncephfjivuh")
    public suspend fun ipPools(vararg argument: suspend IPPoolArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { IPPoolArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipPools = mapped
    }

    /**
     * @param argument network associated pool of IP Addresses
     */
    @JvmName("mkpcaixbgihwdnws")
    public suspend fun ipPools(argument: suspend IPPoolArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IPPoolArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipPools = mapped
    }

    /**
     * @param values network associated pool of IP Addresses
     */
    @JvmName("dukmombaeuxeytwc")
    public suspend fun ipPools(vararg values: IPPoolArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipPools = mapped
    }

    /**
     * @param value Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("ycgljkchhkruwalo")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Route table resource.
     */
    @JvmName("qkomswnswktgkwls")
    public suspend fun routeTable(`value`: RouteTableArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeTable = mapped
    }

    /**
     * @param argument Route table resource.
     */
    @JvmName("ngurccpwypdpnwjn")
    public suspend fun routeTable(argument: suspend RouteTableArgsBuilder.() -> Unit) {
        val toBeMapped = RouteTableArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.routeTable = mapped
    }

    /**
     * @param value Vlan to use for the subnet
     */
    @JvmName("gxfokoiayilrarnt")
    public suspend fun vlan(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vlan = mapped
    }

    internal fun build(): SubnetArgs = SubnetArgs(
        addressPrefix = addressPrefix,
        addressPrefixes = addressPrefixes,
        ipAllocationMethod = ipAllocationMethod,
        ipConfigurationReferences = ipConfigurationReferences,
        ipPools = ipPools,
        name = name,
        routeTable = routeTable,
        vlan = vlan,
    )
}
