@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesDataDisksArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property id Resource ID of the data disk
 */
public data class VirtualMachineInstancePropertiesDataDisksArgs(
    public val id: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesDataDisksArgs> {
    override fun toJava():
        com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesDataDisksArgs =
        com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesDataDisksArgs.builder()
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualMachineInstancePropertiesDataDisksArgs].
 */
@PulumiTagMarker
public class VirtualMachineInstancePropertiesDataDisksArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Resource ID of the data disk
     */
    @JvmName("twsqdgiruvrjjjdt")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource ID of the data disk
     */
    @JvmName("upadhqbcofbjdivg")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): VirtualMachineInstancePropertiesDataDisksArgs =
        VirtualMachineInstancePropertiesDataDisksArgs(
            id = id,
        )
}
