@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesHardwareProfileArgs.builder
import com.pulumi.azurenative.azurestackhci.kotlin.enums.VmSizeEnum
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * HardwareProfile - Specifies the hardware settings for the virtual machine instance.
 * @property dynamicMemoryConfig
 * @property memoryMB RAM in MB for the virtual machine instance
 * @property processors number of processors for the virtual machine instance
 * @property vmSize
 */
public data class VirtualMachineInstancePropertiesHardwareProfileArgs(
    public val dynamicMemoryConfig: Output<VirtualMachineInstancePropertiesDynamicMemoryConfigArgs>? =
        null,
    public val memoryMB: Output<Double>? = null,
    public val processors: Output<Int>? = null,
    public val vmSize: Output<Either<String, VmSizeEnum>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesHardwareProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesHardwareProfileArgs =
        com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesHardwareProfileArgs.builder()
            .dynamicMemoryConfig(
                dynamicMemoryConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .memoryMB(memoryMB?.applyValue({ args0 -> args0 }))
            .processors(processors?.applyValue({ args0 -> args0 }))
            .vmSize(
                vmSize?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [VirtualMachineInstancePropertiesHardwareProfileArgs].
 */
@PulumiTagMarker
public class VirtualMachineInstancePropertiesHardwareProfileArgsBuilder internal constructor() {
    private var dynamicMemoryConfig: Output<VirtualMachineInstancePropertiesDynamicMemoryConfigArgs>? =
        null

    private var memoryMB: Output<Double>? = null

    private var processors: Output<Int>? = null

    private var vmSize: Output<Either<String, VmSizeEnum>>? = null

    /**
     * @param value
     */
    @JvmName("kaayahywgphkkccs")
    public suspend
    fun dynamicMemoryConfig(`value`: Output<VirtualMachineInstancePropertiesDynamicMemoryConfigArgs>) {
        this.dynamicMemoryConfig = value
    }

    /**
     * @param value RAM in MB for the virtual machine instance
     */
    @JvmName("dklwhcsvfahijjsy")
    public suspend fun memoryMB(`value`: Output<Double>) {
        this.memoryMB = value
    }

    /**
     * @param value number of processors for the virtual machine instance
     */
    @JvmName("cmgdahuoykdidhrb")
    public suspend fun processors(`value`: Output<Int>) {
        this.processors = value
    }

    /**
     * @param value
     */
    @JvmName("ahgywauiwoumaatv")
    public suspend fun vmSize(`value`: Output<Either<String, VmSizeEnum>>) {
        this.vmSize = value
    }

    /**
     * @param value
     */
    @JvmName("lawaeuspxpkjpnav")
    public suspend
    fun dynamicMemoryConfig(`value`: VirtualMachineInstancePropertiesDynamicMemoryConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dynamicMemoryConfig = mapped
    }

    /**
     * @param argument
     */
    @JvmName("wkgtjhgwnivxvmud")
    public suspend
    fun dynamicMemoryConfig(argument: suspend VirtualMachineInstancePropertiesDynamicMemoryConfigArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachineInstancePropertiesDynamicMemoryConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dynamicMemoryConfig = mapped
    }

    /**
     * @param value RAM in MB for the virtual machine instance
     */
    @JvmName("wenjcvxuatdctrmf")
    public suspend fun memoryMB(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memoryMB = mapped
    }

    /**
     * @param value number of processors for the virtual machine instance
     */
    @JvmName("dqsfnwedovmxetbo")
    public suspend fun processors(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.processors = mapped
    }

    /**
     * @param value
     */
    @JvmName("bagpshhuqfgwsbbg")
    public suspend fun vmSize(`value`: Either<String, VmSizeEnum>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmSize = mapped
    }

    /**
     * @param value
     */
    @JvmName("afquybddbnshgfnd")
    public fun vmSize(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VmSizeEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vmSize = mapped
    }

    /**
     * @param value
     */
    @JvmName("rstxvwhhdsucibrj")
    public fun vmSize(`value`: VmSizeEnum) {
        val toBeMapped = Either.ofRight<String, VmSizeEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vmSize = mapped
    }

    internal fun build(): VirtualMachineInstancePropertiesHardwareProfileArgs =
        VirtualMachineInstancePropertiesHardwareProfileArgs(
            dynamicMemoryConfig = dynamicMemoryConfig,
            memoryMB = memoryMB,
            processors = processors,
            vmSize = vmSize,
        )
}
