@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesUefiSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property secureBootEnabled Specifies whether secure boot should be enabled on the virtual machine instance.
 */
public data class VirtualMachineInstancePropertiesUefiSettingsArgs(
    public val secureBootEnabled: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesUefiSettingsArgs> {
    override fun toJava():
        com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesUefiSettingsArgs =
        com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesUefiSettingsArgs.builder()
            .secureBootEnabled(secureBootEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualMachineInstancePropertiesUefiSettingsArgs].
 */
@PulumiTagMarker
public class VirtualMachineInstancePropertiesUefiSettingsArgsBuilder internal constructor() {
    private var secureBootEnabled: Output<Boolean>? = null

    /**
     * @param value Specifies whether secure boot should be enabled on the virtual machine instance.
     */
    @JvmName("iavsfotgcqxjovtp")
    public suspend fun secureBootEnabled(`value`: Output<Boolean>) {
        this.secureBootEnabled = value
    }

    /**
     * @param value Specifies whether secure boot should be enabled on the virtual machine instance.
     */
    @JvmName("rfnjsbrlbirmyfij")
    public suspend fun secureBootEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secureBootEnabled = mapped
    }

    internal fun build(): VirtualMachineInstancePropertiesUefiSettingsArgs =
        VirtualMachineInstancePropertiesUefiSettingsArgs(
            secureBootEnabled = secureBootEnabled,
        )
}
