@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesWindowsConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Windows Configuration for the virtual machine instance
 * @property enableAutomaticUpdates Whether to EnableAutomaticUpdates on the machine
 * @property provisionVMAgent Used to indicate whether Arc for Servers agent onboarding should be triggered during the virtual machine instance creation process.
 * @property provisionVMConfigAgent Used to indicate whether the VM Config Agent should be installed during the virtual machine creation process.
 * @property ssh Specifies the ssh key configuration for Windows OS.
 * @property timeZone TimeZone for the virtual machine instance
 */
public data class VirtualMachineInstancePropertiesWindowsConfigurationArgs(
    public val enableAutomaticUpdates: Output<Boolean>? = null,
    public val provisionVMAgent: Output<Boolean>? = null,
    public val provisionVMConfigAgent: Output<Boolean>? = null,
    public val ssh: Output<SshConfigurationArgs>? = null,
    public val timeZone: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesWindowsConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesWindowsConfigurationArgs =
        com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesWindowsConfigurationArgs.builder()
            .enableAutomaticUpdates(enableAutomaticUpdates?.applyValue({ args0 -> args0 }))
            .provisionVMAgent(provisionVMAgent?.applyValue({ args0 -> args0 }))
            .provisionVMConfigAgent(provisionVMConfigAgent?.applyValue({ args0 -> args0 }))
            .ssh(ssh?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .timeZone(timeZone?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualMachineInstancePropertiesWindowsConfigurationArgs].
 */
@PulumiTagMarker
public class VirtualMachineInstancePropertiesWindowsConfigurationArgsBuilder internal constructor() {
    private var enableAutomaticUpdates: Output<Boolean>? = null

    private var provisionVMAgent: Output<Boolean>? = null

    private var provisionVMConfigAgent: Output<Boolean>? = null

    private var ssh: Output<SshConfigurationArgs>? = null

    private var timeZone: Output<String>? = null

    /**
     * @param value Whether to EnableAutomaticUpdates on the machine
     */
    @JvmName("sphcqlmodphglsig")
    public suspend fun enableAutomaticUpdates(`value`: Output<Boolean>) {
        this.enableAutomaticUpdates = value
    }

    /**
     * @param value Used to indicate whether Arc for Servers agent onboarding should be triggered during the virtual machine instance creation process.
     */
    @JvmName("sccckutymtquqyul")
    public suspend fun provisionVMAgent(`value`: Output<Boolean>) {
        this.provisionVMAgent = value
    }

    /**
     * @param value Used to indicate whether the VM Config Agent should be installed during the virtual machine creation process.
     */
    @JvmName("sxsigosghdqmcqnf")
    public suspend fun provisionVMConfigAgent(`value`: Output<Boolean>) {
        this.provisionVMConfigAgent = value
    }

    /**
     * @param value Specifies the ssh key configuration for Windows OS.
     */
    @JvmName("psfyuitjntqgidoh")
    public suspend fun ssh(`value`: Output<SshConfigurationArgs>) {
        this.ssh = value
    }

    /**
     * @param value TimeZone for the virtual machine instance
     */
    @JvmName("gikeaykpfqhfpbki")
    public suspend fun timeZone(`value`: Output<String>) {
        this.timeZone = value
    }

    /**
     * @param value Whether to EnableAutomaticUpdates on the machine
     */
    @JvmName("faygsqwgolqusgwl")
    public suspend fun enableAutomaticUpdates(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAutomaticUpdates = mapped
    }

    /**
     * @param value Used to indicate whether Arc for Servers agent onboarding should be triggered during the virtual machine instance creation process.
     */
    @JvmName("ksvrscxyfgjqqfyt")
    public suspend fun provisionVMAgent(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisionVMAgent = mapped
    }

    /**
     * @param value Used to indicate whether the VM Config Agent should be installed during the virtual machine creation process.
     */
    @JvmName("pjiwfkyfvkpxvuip")
    public suspend fun provisionVMConfigAgent(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisionVMConfigAgent = mapped
    }

    /**
     * @param value Specifies the ssh key configuration for Windows OS.
     */
    @JvmName("annyvxucyfcljjbd")
    public suspend fun ssh(`value`: SshConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ssh = mapped
    }

    /**
     * @param argument Specifies the ssh key configuration for Windows OS.
     */
    @JvmName("pgonndxlaysxwbuh")
    public suspend fun ssh(argument: suspend SshConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = SshConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ssh = mapped
    }

    /**
     * @param value TimeZone for the virtual machine instance
     */
    @JvmName("swguwlamrhxwmeec")
    public suspend fun timeZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeZone = mapped
    }

    internal fun build(): VirtualMachineInstancePropertiesWindowsConfigurationArgs =
        VirtualMachineInstancePropertiesWindowsConfigurationArgs(
            enableAutomaticUpdates = enableAutomaticUpdates,
            provisionVMAgent = provisionVMAgent,
            provisionVMConfigAgent = provisionVMConfigAgent,
            ssh = ssh,
            timeZone = timeZone,
        )
}
