@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesDynamicMemoryConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property maximumMemoryMB
 * @property minimumMemoryMB
 * @property targetMemoryBuffer Defines the amount of extra memory that should be reserved for a virtual machine at runtime, as a percentage of the total memory that the virtual machine is thought to need. This only applies to virtual systems with dynamic memory enabled. This property can be in the range of 5 to 2000.
 */
public data class VirtualMachinePropertiesDynamicMemoryConfigArgs(
    public val maximumMemoryMB: Output<Double>? = null,
    public val minimumMemoryMB: Output<Double>? = null,
    public val targetMemoryBuffer: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesDynamicMemoryConfigArgs> {
    override fun toJava():
        com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesDynamicMemoryConfigArgs =
        com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesDynamicMemoryConfigArgs.builder()
            .maximumMemoryMB(maximumMemoryMB?.applyValue({ args0 -> args0 }))
            .minimumMemoryMB(minimumMemoryMB?.applyValue({ args0 -> args0 }))
            .targetMemoryBuffer(targetMemoryBuffer?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualMachinePropertiesDynamicMemoryConfigArgs].
 */
@PulumiTagMarker
public class VirtualMachinePropertiesDynamicMemoryConfigArgsBuilder internal constructor() {
    private var maximumMemoryMB: Output<Double>? = null

    private var minimumMemoryMB: Output<Double>? = null

    private var targetMemoryBuffer: Output<Int>? = null

    /**
     * @param value
     */
    @JvmName("qyafomqtkfixqbbc")
    public suspend fun maximumMemoryMB(`value`: Output<Double>) {
        this.maximumMemoryMB = value
    }

    /**
     * @param value
     */
    @JvmName("taxfmxucmgnewmdv")
    public suspend fun minimumMemoryMB(`value`: Output<Double>) {
        this.minimumMemoryMB = value
    }

    /**
     * @param value Defines the amount of extra memory that should be reserved for a virtual machine at runtime, as a percentage of the total memory that the virtual machine is thought to need. This only applies to virtual systems with dynamic memory enabled. This property can be in the range of 5 to 2000.
     */
    @JvmName("nnvadlkldmyeqwjd")
    public suspend fun targetMemoryBuffer(`value`: Output<Int>) {
        this.targetMemoryBuffer = value
    }

    /**
     * @param value
     */
    @JvmName("rqnkyviunuspnibn")
    public suspend fun maximumMemoryMB(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumMemoryMB = mapped
    }

    /**
     * @param value
     */
    @JvmName("qindmlskwhgimqiy")
    public suspend fun minimumMemoryMB(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minimumMemoryMB = mapped
    }

    /**
     * @param value Defines the amount of extra memory that should be reserved for a virtual machine at runtime, as a percentage of the total memory that the virtual machine is thought to need. This only applies to virtual systems with dynamic memory enabled. This property can be in the range of 5 to 2000.
     */
    @JvmName("ypegougdsdphhdxg")
    public suspend fun targetMemoryBuffer(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetMemoryBuffer = mapped
    }

    internal fun build(): VirtualMachinePropertiesDynamicMemoryConfigArgs =
        VirtualMachinePropertiesDynamicMemoryConfigArgs(
            maximumMemoryMB = maximumMemoryMB,
            minimumMemoryMB = minimumMemoryMB,
            targetMemoryBuffer = targetMemoryBuffer,
        )
}
