@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesLinuxConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * LinuxConfiguration - linux specific configuration values for the virtual machine
 * @property disablePasswordAuthentication DisablePasswordAuthentication - whether password authentication should be disabled
 * @property provisionVMAgent Used to indicate whether Arc for Servers agent onboarding should be triggered during the virtual machine creation process.
 * @property ssh SSH - contains settings related to ssh configuration
 */
public data class VirtualMachinePropertiesLinuxConfigurationArgs(
    public val disablePasswordAuthentication: Output<Boolean>? = null,
    public val provisionVMAgent: Output<Boolean>? = null,
    public val ssh: Output<VirtualMachinePropertiesSshArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesLinuxConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesLinuxConfigurationArgs =
        com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesLinuxConfigurationArgs.builder()
            .disablePasswordAuthentication(disablePasswordAuthentication?.applyValue({ args0 -> args0 }))
            .provisionVMAgent(provisionVMAgent?.applyValue({ args0 -> args0 }))
            .ssh(ssh?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualMachinePropertiesLinuxConfigurationArgs].
 */
@PulumiTagMarker
public class VirtualMachinePropertiesLinuxConfigurationArgsBuilder internal constructor() {
    private var disablePasswordAuthentication: Output<Boolean>? = null

    private var provisionVMAgent: Output<Boolean>? = null

    private var ssh: Output<VirtualMachinePropertiesSshArgs>? = null

    /**
     * @param value DisablePasswordAuthentication - whether password authentication should be disabled
     */
    @JvmName("lhdamnusycqcpqjw")
    public suspend fun disablePasswordAuthentication(`value`: Output<Boolean>) {
        this.disablePasswordAuthentication = value
    }

    /**
     * @param value Used to indicate whether Arc for Servers agent onboarding should be triggered during the virtual machine creation process.
     */
    @JvmName("vlslnwijkhjavoce")
    public suspend fun provisionVMAgent(`value`: Output<Boolean>) {
        this.provisionVMAgent = value
    }

    /**
     * @param value SSH - contains settings related to ssh configuration
     */
    @JvmName("nstpoxbijtvhwknu")
    public suspend fun ssh(`value`: Output<VirtualMachinePropertiesSshArgs>) {
        this.ssh = value
    }

    /**
     * @param value DisablePasswordAuthentication - whether password authentication should be disabled
     */
    @JvmName("dklcvfgywvwhisjm")
    public suspend fun disablePasswordAuthentication(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disablePasswordAuthentication = mapped
    }

    /**
     * @param value Used to indicate whether Arc for Servers agent onboarding should be triggered during the virtual machine creation process.
     */
    @JvmName("qvvffudyfkfiqqqe")
    public suspend fun provisionVMAgent(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisionVMAgent = mapped
    }

    /**
     * @param value SSH - contains settings related to ssh configuration
     */
    @JvmName("mnphlsoepwswwerk")
    public suspend fun ssh(`value`: VirtualMachinePropertiesSshArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ssh = mapped
    }

    /**
     * @param argument SSH - contains settings related to ssh configuration
     */
    @JvmName("rlniftbwfafwejfx")
    public suspend fun ssh(argument: suspend VirtualMachinePropertiesSshArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachinePropertiesSshArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ssh = mapped
    }

    internal fun build(): VirtualMachinePropertiesLinuxConfigurationArgs =
        VirtualMachinePropertiesLinuxConfigurationArgs(
            disablePasswordAuthentication = disablePasswordAuthentication,
            provisionVMAgent = provisionVMAgent,
            ssh = ssh,
        )
}
