@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesNetworkProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * NetworkProfile - describes the network configuration the virtual machine
 * @property networkInterfaces NetworkInterfaces - list of network interfaces to be attached to the virtual machine
 */
public data class VirtualMachinePropertiesNetworkProfileArgs(
    public val networkInterfaces: Output<List<VirtualMachinePropertiesNetworkInterfacesArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesNetworkProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesNetworkProfileArgs =
        com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesNetworkProfileArgs.builder()
            .networkInterfaces(
                networkInterfaces?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [VirtualMachinePropertiesNetworkProfileArgs].
 */
@PulumiTagMarker
public class VirtualMachinePropertiesNetworkProfileArgsBuilder internal constructor() {
    private var networkInterfaces: Output<List<VirtualMachinePropertiesNetworkInterfacesArgs>>? = null

    /**
     * @param value NetworkInterfaces - list of network interfaces to be attached to the virtual machine
     */
    @JvmName("cmudxwoqhokbwwqr")
    public suspend
    fun networkInterfaces(`value`: Output<List<VirtualMachinePropertiesNetworkInterfacesArgs>>) {
        this.networkInterfaces = value
    }

    @JvmName("kemxgbqolmvygwve")
    public suspend fun networkInterfaces(
        vararg
        values: Output<VirtualMachinePropertiesNetworkInterfacesArgs>,
    ) {
        this.networkInterfaces = Output.all(values.asList())
    }

    /**
     * @param values NetworkInterfaces - list of network interfaces to be attached to the virtual machine
     */
    @JvmName("gbjgbwnhldbjhxyh")
    public suspend
    fun networkInterfaces(values: List<Output<VirtualMachinePropertiesNetworkInterfacesArgs>>) {
        this.networkInterfaces = Output.all(values)
    }

    /**
     * @param value NetworkInterfaces - list of network interfaces to be attached to the virtual machine
     */
    @JvmName("doxvriktprqdtsej")
    public suspend
    fun networkInterfaces(`value`: List<VirtualMachinePropertiesNetworkInterfacesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaces = mapped
    }

    /**
     * @param argument NetworkInterfaces - list of network interfaces to be attached to the virtual machine
     */
    @JvmName("dniowqbtmmldeehe")
    public suspend
    fun networkInterfaces(argument: List<suspend VirtualMachinePropertiesNetworkInterfacesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualMachinePropertiesNetworkInterfacesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkInterfaces = mapped
    }

    /**
     * @param argument NetworkInterfaces - list of network interfaces to be attached to the virtual machine
     */
    @JvmName("xpbjwshcowpscird")
    public suspend fun networkInterfaces(
        vararg
        argument: suspend VirtualMachinePropertiesNetworkInterfacesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VirtualMachinePropertiesNetworkInterfacesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkInterfaces = mapped
    }

    /**
     * @param argument NetworkInterfaces - list of network interfaces to be attached to the virtual machine
     */
    @JvmName("goudxwtnkvvfebmm")
    public suspend
    fun networkInterfaces(argument: suspend VirtualMachinePropertiesNetworkInterfacesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VirtualMachinePropertiesNetworkInterfacesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.networkInterfaces = mapped
    }

    /**
     * @param values NetworkInterfaces - list of network interfaces to be attached to the virtual machine
     */
    @JvmName("idissowyshuettvu")
    public suspend fun networkInterfaces(
        vararg
        values: VirtualMachinePropertiesNetworkInterfacesArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkInterfaces = mapped
    }

    internal fun build(): VirtualMachinePropertiesNetworkProfileArgs =
        VirtualMachinePropertiesNetworkProfileArgs(
            networkInterfaces = networkInterfaces,
        )
}
