@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesOsDiskArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * VHD to attach as OS disk
 * @property id Resource ID of the OS disk
 */
public data class VirtualMachinePropertiesOsDiskArgs(
    public val id: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesOsDiskArgs> {
    override fun toJava():
        com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesOsDiskArgs =
        com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesOsDiskArgs.builder()
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualMachinePropertiesOsDiskArgs].
 */
@PulumiTagMarker
public class VirtualMachinePropertiesOsDiskArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Resource ID of the OS disk
     */
    @JvmName("yrqxvnvlmvrglmos")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource ID of the OS disk
     */
    @JvmName("hiscgqhccjloclvv")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): VirtualMachinePropertiesOsDiskArgs = VirtualMachinePropertiesOsDiskArgs(
        id = id,
    )
}
