@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesWindowsConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Windows Configuration for the virtual machine
 * @property enableAutomaticUpdates Whether to EnableAutomaticUpdates on the machine
 * @property provisionVMAgent Used to indicate whether Arc for Servers agent onboarding should be triggered during the virtual machine creation process.
 * @property ssh SSH Configuration
 * @property timeZone TimeZone for the virtual machine
 */
public data class VirtualMachinePropertiesWindowsConfigurationArgs(
    public val enableAutomaticUpdates: Output<Boolean>? = null,
    public val provisionVMAgent: Output<Boolean>? = null,
    public val ssh: Output<VirtualMachinePropertiesSshSshArgs>? = null,
    public val timeZone: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesWindowsConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesWindowsConfigurationArgs =
        com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesWindowsConfigurationArgs.builder()
            .enableAutomaticUpdates(enableAutomaticUpdates?.applyValue({ args0 -> args0 }))
            .provisionVMAgent(provisionVMAgent?.applyValue({ args0 -> args0 }))
            .ssh(ssh?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .timeZone(timeZone?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualMachinePropertiesWindowsConfigurationArgs].
 */
@PulumiTagMarker
public class VirtualMachinePropertiesWindowsConfigurationArgsBuilder internal constructor() {
    private var enableAutomaticUpdates: Output<Boolean>? = null

    private var provisionVMAgent: Output<Boolean>? = null

    private var ssh: Output<VirtualMachinePropertiesSshSshArgs>? = null

    private var timeZone: Output<String>? = null

    /**
     * @param value Whether to EnableAutomaticUpdates on the machine
     */
    @JvmName("cwkitccsesbywhoy")
    public suspend fun enableAutomaticUpdates(`value`: Output<Boolean>) {
        this.enableAutomaticUpdates = value
    }

    /**
     * @param value Used to indicate whether Arc for Servers agent onboarding should be triggered during the virtual machine creation process.
     */
    @JvmName("gtmnjsboxhpefunr")
    public suspend fun provisionVMAgent(`value`: Output<Boolean>) {
        this.provisionVMAgent = value
    }

    /**
     * @param value SSH Configuration
     */
    @JvmName("crhymvvgevfhkgyx")
    public suspend fun ssh(`value`: Output<VirtualMachinePropertiesSshSshArgs>) {
        this.ssh = value
    }

    /**
     * @param value TimeZone for the virtual machine
     */
    @JvmName("amjtrsmfrrfndhil")
    public suspend fun timeZone(`value`: Output<String>) {
        this.timeZone = value
    }

    /**
     * @param value Whether to EnableAutomaticUpdates on the machine
     */
    @JvmName("ltswjctwgkgccvwt")
    public suspend fun enableAutomaticUpdates(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAutomaticUpdates = mapped
    }

    /**
     * @param value Used to indicate whether Arc for Servers agent onboarding should be triggered during the virtual machine creation process.
     */
    @JvmName("kfwtpigkneieqnbe")
    public suspend fun provisionVMAgent(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisionVMAgent = mapped
    }

    /**
     * @param value SSH Configuration
     */
    @JvmName("elfdexoidyptkywn")
    public suspend fun ssh(`value`: VirtualMachinePropertiesSshSshArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ssh = mapped
    }

    /**
     * @param argument SSH Configuration
     */
    @JvmName("mxahnulhnkxbwome")
    public suspend fun ssh(argument: suspend VirtualMachinePropertiesSshSshArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachinePropertiesSshSshArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ssh = mapped
    }

    /**
     * @param value TimeZone for the virtual machine
     */
    @JvmName("yovjnpytqvighdvl")
    public suspend fun timeZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeZone = mapped
    }

    internal fun build(): VirtualMachinePropertiesWindowsConfigurationArgs =
        VirtualMachinePropertiesWindowsConfigurationArgs(
            enableAutomaticUpdates = enableAutomaticUpdates,
            provisionVMAgent = provisionVMAgent,
            ssh = ssh,
            timeZone = timeZone,
        )
}
