@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.VirtualNetworkPropertiesIpConfigurationReferencesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * IPConfigurationReference - Describes a IPConfiguration under the virtual network
 * @property id IPConfigurationID
 */
public data class VirtualNetworkPropertiesIpConfigurationReferencesArgs(
    public val id: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.VirtualNetworkPropertiesIpConfigurationReferencesArgs> {
    override fun toJava():
        com.pulumi.azurenative.azurestackhci.inputs.VirtualNetworkPropertiesIpConfigurationReferencesArgs =
        com.pulumi.azurenative.azurestackhci.inputs.VirtualNetworkPropertiesIpConfigurationReferencesArgs.builder()
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNetworkPropertiesIpConfigurationReferencesArgs].
 */
@PulumiTagMarker
public class VirtualNetworkPropertiesIpConfigurationReferencesArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value IPConfigurationID
     */
    @JvmName("ivjvhgapbvhvsgtv")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value IPConfigurationID
     */
    @JvmName("osnhmamrbavypquc")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): VirtualNetworkPropertiesIpConfigurationReferencesArgs =
        VirtualNetworkPropertiesIpConfigurationReferencesArgs(
            id = id,
        )
}
