@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.Double
import kotlin.Suppress

/**
 * This is the OS disk image.
 * @property sizeInMB This property indicates the size of the VHD to be created.
 */
public data class GalleryOSDiskImageResponse(
    public val sizeInMB: Double,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.GalleryOSDiskImageResponse):
            GalleryOSDiskImageResponse = GalleryOSDiskImageResponse(
            sizeInMB = javaType.sizeInMB(),
        )
    }
}
