@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the GuestAgent.
 * @property credentials Username / Password Credentials to provision guest agent.
 * @property httpProxyConfig HTTP Proxy configuration for the VM.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property provisioningAction The guest agent provisioning action.
 * @property provisioningState The provisioning state.
 * @property status The guest agent status.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetGuestAgentResult(
    public val credentials: GuestCredentialResponse? = null,
    public val httpProxyConfig: HttpProxyConfigurationResponse? = null,
    public val id: String,
    public val name: String,
    public val provisioningAction: String? = null,
    public val provisioningState: String,
    public val status: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.GetGuestAgentResult):
            GetGuestAgentResult = GetGuestAgentResult(
            credentials = javaType.credentials().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.GuestCredentialResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            httpProxyConfig = javaType.httpProxyConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.HttpProxyConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            provisioningAction = javaType.provisioningAction().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            status = javaType.status(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.azurestackhci.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
