@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress
import kotlin.collections.List

/**
 * The HostNetwork of a cluster.
 * @property enableStorageAutoIp Optional parameter required only for 3 Nodes Switchless deployments. This allows users to specify IPs and Mask for Storage NICs when Network ATC is not assigning the IPs for storage automatically.
 * @property intents The network intents assigned to the network reference pattern used for the deployment. Each intent will define its own name, traffic type, adapter names, and overrides as recommended by your OEM.
 * @property storageConnectivitySwitchless Defines how the storage adapters between nodes are connected either switch or switch less..
 * @property storageNetworks List of StorageNetworks config to deploy AzureStackHCI Cluster.
 */
public data class HostNetworkResponse(
    public val enableStorageAutoIp: Boolean? = null,
    public val intents: List<IntentsResponse>? = null,
    public val storageConnectivitySwitchless: Boolean? = null,
    public val storageNetworks: List<StorageNetworksResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.HostNetworkResponse):
            HostNetworkResponse = HostNetworkResponse(
            enableStorageAutoIp = javaType.enableStorageAutoIp().map({ args0 -> args0 }).orElse(null),
            intents = javaType.intents().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.IntentsResponse.Companion.toKotlin(args0)
                })
            }),
            storageConnectivitySwitchless = javaType.storageConnectivitySwitchless().map({ args0 ->
                args0
            }).orElse(null),
            storageNetworks = javaType.storageNetworks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.StorageNetworksResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
