@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * DhcpOptions contains an array of DNS servers available to VMs deployed in the logical network. Standard DHCP option for a subnet overrides logical network DHCP options.
 * @property dnsServers The list of DNS servers IP addresses.
 */
public data class LogicalNetworkPropertiesResponseDhcpOptions(
    public val dnsServers: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.LogicalNetworkPropertiesResponseDhcpOptions):
            LogicalNetworkPropertiesResponseDhcpOptions = LogicalNetworkPropertiesResponseDhcpOptions(
            dnsServers = javaType.dnsServers().map({ args0 -> args0 }),
        )
    }
}
