@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Progress representation of the update run steps.
 * @property description More detailed description of the step.
 * @property endTimeUtc When the step reached a terminal state.
 * @property errorMessage Error message, specified if the step is in a failed state.
 * @property exception List of exceptions in AzureStackHCI Cluster Deployment.
 * @property fullStepIndex FullStepIndex of step.
 * @property lastUpdatedTimeUtc Completion time of this step or the last completed sub-step.
 * @property name Name of the step.
 * @property startTimeUtc When the step started, or empty if it has not started executing.
 * @property status Status of the step, bubbled up from the ECE action plan for installation attempts. Values are: 'Success', 'Error', 'InProgress', and 'Unknown status'.
 * @property steps Recursive model for child steps of this step.
 */
public data class StepResponse(
    public val description: String? = null,
    public val endTimeUtc: String? = null,
    public val errorMessage: String? = null,
    public val exception: List<String>? = null,
    public val fullStepIndex: String? = null,
    public val lastUpdatedTimeUtc: String? = null,
    public val name: String? = null,
    public val startTimeUtc: String? = null,
    public val status: String? = null,
    public val steps: List<StepResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.StepResponse):
            StepResponse = StepResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            endTimeUtc = javaType.endTimeUtc().map({ args0 -> args0 }).orElse(null),
            errorMessage = javaType.errorMessage().map({ args0 -> args0 }).orElse(null),
            exception = javaType.exception().map({ args0 -> args0 }),
            fullStepIndex = javaType.fullStepIndex().map({ args0 -> args0 }).orElse(null),
            lastUpdatedTimeUtc = javaType.lastUpdatedTimeUtc().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            startTimeUtc = javaType.startTimeUtc().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            steps = javaType.steps().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.StepResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
