@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * HardwareProfile - Specifies the hardware settings for the virtual machine instance.
 * @property dynamicMemoryConfig
 * @property memoryMB RAM in MB for the virtual machine instance
 * @property processors number of processors for the virtual machine instance
 * @property vmSize
 */
public data class VirtualMachineInstancePropertiesResponseHardwareProfile(
    public val dynamicMemoryConfig: VirtualMachineInstancePropertiesResponseDynamicMemoryConfig? =
        null,
    public val memoryMB: Double? = null,
    public val processors: Int? = null,
    public val vmSize: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.VirtualMachineInstancePropertiesResponseHardwareProfile):
            VirtualMachineInstancePropertiesResponseHardwareProfile =
            VirtualMachineInstancePropertiesResponseHardwareProfile(
                dynamicMemoryConfig = javaType.dynamicMemoryConfig().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachineInstancePropertiesResponseDynamicMemoryConfig.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                memoryMB = javaType.memoryMB().map({ args0 -> args0 }).orElse(null),
                processors = javaType.processors().map({ args0 -> args0 }).orElse(null),
                vmSize = javaType.vmSize().map({ args0 -> args0 }).orElse(null),
            )
    }
}
