@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * OsProfile - describes the configuration of the operating system and sets login data
 * @property adminUsername AdminUsername - admin username
 * @property computerName ComputerName - name of the compute
 * @property linuxConfiguration LinuxConfiguration - linux specific configuration values for the virtual machine instance
 * @property windowsConfiguration Windows Configuration for the virtual machine instance
 */
public data class VirtualMachineInstancePropertiesResponseOsProfile(
    public val adminUsername: String? = null,
    public val computerName: String? = null,
    public val linuxConfiguration: VirtualMachineInstancePropertiesResponseLinuxConfiguration? = null,
    public val windowsConfiguration: VirtualMachineInstancePropertiesResponseWindowsConfiguration? =
        null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.VirtualMachineInstancePropertiesResponseOsProfile):
            VirtualMachineInstancePropertiesResponseOsProfile =
            VirtualMachineInstancePropertiesResponseOsProfile(
                adminUsername = javaType.adminUsername().map({ args0 -> args0 }).orElse(null),
                computerName = javaType.computerName().map({ args0 -> args0 }).orElse(null),
                linuxConfiguration = javaType.linuxConfiguration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachineInstancePropertiesResponseLinuxConfiguration.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                windowsConfiguration = javaType.windowsConfiguration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachineInstancePropertiesResponseWindowsConfiguration.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
