@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * SecurityProfile - Specifies the security settings for the virtual machine instance.
 * @property enableTPM
 * @property securityType Specifies the SecurityType of the virtual machine. EnableTPM and SecureBootEnabled must be set to true for SecurityType to function.
 * @property uefiSettings
 */
public data class VirtualMachineInstancePropertiesResponseSecurityProfile(
    public val enableTPM: Boolean? = null,
    public val securityType: String? = null,
    public val uefiSettings: VirtualMachineInstancePropertiesResponseUefiSettings? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.VirtualMachineInstancePropertiesResponseSecurityProfile):
            VirtualMachineInstancePropertiesResponseSecurityProfile =
            VirtualMachineInstancePropertiesResponseSecurityProfile(
                enableTPM = javaType.enableTPM().map({ args0 -> args0 }).orElse(null),
                securityType = javaType.securityType().map({ args0 -> args0 }).orElse(null),
                uefiSettings = javaType.uefiSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachineInstancePropertiesResponseUefiSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
