@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property maximumMemoryMB
 * @property minimumMemoryMB
 * @property targetMemoryBuffer Defines the amount of extra memory that should be reserved for a virtual machine at runtime, as a percentage of the total memory that the virtual machine is thought to need. This only applies to virtual systems with dynamic memory enabled. This property can be in the range of 5 to 2000.
 */
public data class VirtualMachinePropertiesResponseDynamicMemoryConfig(
    public val maximumMemoryMB: Double? = null,
    public val minimumMemoryMB: Double? = null,
    public val targetMemoryBuffer: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.VirtualMachinePropertiesResponseDynamicMemoryConfig):
            VirtualMachinePropertiesResponseDynamicMemoryConfig =
            VirtualMachinePropertiesResponseDynamicMemoryConfig(
                maximumMemoryMB = javaType.maximumMemoryMB().map({ args0 -> args0 }).orElse(null),
                minimumMemoryMB = javaType.minimumMemoryMB().map({ args0 -> args0 }).orElse(null),
                targetMemoryBuffer = javaType.targetMemoryBuffer().map({ args0 -> args0 }).orElse(null),
            )
    }
}
