@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * SecurityProfile - Specifies the security settings for the virtual machine.
 * @property enableTPM
 * @property uefiSettings
 */
public data class VirtualMachinePropertiesResponseSecurityProfile(
    public val enableTPM: Boolean? = null,
    public val uefiSettings: VirtualMachinePropertiesResponseUefiSettings? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.VirtualMachinePropertiesResponseSecurityProfile):
            VirtualMachinePropertiesResponseSecurityProfile =
            VirtualMachinePropertiesResponseSecurityProfile(
                enableTPM = javaType.enableTPM().map({ args0 -> args0 }).orElse(null),
                uefiSettings = javaType.uefiSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachinePropertiesResponseUefiSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
