@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * SSH - contains settings related to ssh configuration
 * @property publicKeys PublicKeys - The list of SSH public keys used to authenticate with linux based VMs.
 */
public data class VirtualMachinePropertiesResponseSsh(
    public val publicKeys: List<VirtualMachinePropertiesResponsePublicKeys>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.VirtualMachinePropertiesResponseSsh):
            VirtualMachinePropertiesResponseSsh = VirtualMachinePropertiesResponseSsh(
            publicKeys = javaType.publicKeys().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachinePropertiesResponsePublicKeys.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
