@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The observed state of virtual networks
 * @property errorCode VirtualNetwork provisioning error code
 * @property errorMessage Descriptive error message
 * @property provisioningStatus
 */
public data class VirtualNetworkStatusResponse(
    public val errorCode: String? = null,
    public val errorMessage: String? = null,
    public val provisioningStatus: VirtualNetworkStatusResponseProvisioningStatus? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.VirtualNetworkStatusResponse):
            VirtualNetworkStatusResponse = VirtualNetworkStatusResponse(
            errorCode = javaType.errorCode().map({ args0 -> args0 }).orElse(null),
            errorMessage = javaType.errorMessage().map({ args0 -> args0 }).orElse(null),
            provisioningStatus = javaType.provisioningStatus().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualNetworkStatusResponseProvisioningStatus.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
