@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.baremetalinfrastructure.kotlin.inputs

import com.pulumi.azurenative.baremetalinfrastructure.inputs.GetAzureBareMetalStorageInstancePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property azureBareMetalStorageInstanceName Name of the AzureBareMetalStorage on Azure instance.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetAzureBareMetalStorageInstancePlainArgs(
    public val azureBareMetalStorageInstanceName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.baremetalinfrastructure.inputs.GetAzureBareMetalStorageInstancePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.baremetalinfrastructure.inputs.GetAzureBareMetalStorageInstancePlainArgs =
        com.pulumi.azurenative.baremetalinfrastructure.inputs.GetAzureBareMetalStorageInstancePlainArgs.builder()
            .azureBareMetalStorageInstanceName(azureBareMetalStorageInstanceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAzureBareMetalStorageInstancePlainArgs].
 */
@PulumiTagMarker
public class GetAzureBareMetalStorageInstancePlainArgsBuilder internal constructor() {
    private var azureBareMetalStorageInstanceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the AzureBareMetalStorage on Azure instance.
     */
    @JvmName("uucvsjkaskqlbied")
    public suspend fun azureBareMetalStorageInstanceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.azureBareMetalStorageInstanceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("patcjajjvbyvrejq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAzureBareMetalStorageInstancePlainArgs =
        GetAzureBareMetalStorageInstancePlainArgs(
            azureBareMetalStorageInstanceName = azureBareMetalStorageInstanceName ?: throw
                PulumiNullFieldException("azureBareMetalStorageInstanceName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
