@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin

import com.pulumi.azurenative.batch.PoolArgs.builder
import com.pulumi.azurenative.batch.kotlin.enums.InterNodeCommunicationState
import com.pulumi.azurenative.batch.kotlin.enums.NodeCommunicationMode
import com.pulumi.azurenative.batch.kotlin.inputs.ApplicationPackageReferenceArgs
import com.pulumi.azurenative.batch.kotlin.inputs.ApplicationPackageReferenceArgsBuilder
import com.pulumi.azurenative.batch.kotlin.inputs.BatchPoolIdentityArgs
import com.pulumi.azurenative.batch.kotlin.inputs.BatchPoolIdentityArgsBuilder
import com.pulumi.azurenative.batch.kotlin.inputs.CertificateReferenceArgs
import com.pulumi.azurenative.batch.kotlin.inputs.CertificateReferenceArgsBuilder
import com.pulumi.azurenative.batch.kotlin.inputs.DeploymentConfigurationArgs
import com.pulumi.azurenative.batch.kotlin.inputs.DeploymentConfigurationArgsBuilder
import com.pulumi.azurenative.batch.kotlin.inputs.MetadataItemArgs
import com.pulumi.azurenative.batch.kotlin.inputs.MetadataItemArgsBuilder
import com.pulumi.azurenative.batch.kotlin.inputs.MountConfigurationArgs
import com.pulumi.azurenative.batch.kotlin.inputs.MountConfigurationArgsBuilder
import com.pulumi.azurenative.batch.kotlin.inputs.NetworkConfigurationArgs
import com.pulumi.azurenative.batch.kotlin.inputs.NetworkConfigurationArgsBuilder
import com.pulumi.azurenative.batch.kotlin.inputs.ScaleSettingsArgs
import com.pulumi.azurenative.batch.kotlin.inputs.ScaleSettingsArgsBuilder
import com.pulumi.azurenative.batch.kotlin.inputs.StartTaskArgs
import com.pulumi.azurenative.batch.kotlin.inputs.StartTaskArgsBuilder
import com.pulumi.azurenative.batch.kotlin.inputs.TaskSchedulingPolicyArgs
import com.pulumi.azurenative.batch.kotlin.inputs.TaskSchedulingPolicyArgsBuilder
import com.pulumi.azurenative.batch.kotlin.inputs.UserAccountArgs
import com.pulumi.azurenative.batch.kotlin.inputs.UserAccountArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Contains information about a pool.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * Other available API versions: 2020-05-01, 2023-11-01.
 * ## Example Usage
 * ### CreatePool - Custom Image
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pool = new AzureNative.Batch.Pool("pool", new()
 *     {
 *         AccountName = "sampleacct",
 *         DeploymentConfiguration = new AzureNative.Batch.Inputs.DeploymentConfigurationArgs
 *         {
 *             VirtualMachineConfiguration = new AzureNative.Batch.Inputs.VirtualMachineConfigurationArgs
 *             {
 *                 ImageReference = new AzureNative.Batch.Inputs.ImageReferenceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/networking-group/providers/Microsoft.Compute/galleries/testgallery/images/testimagedef/versions/0.0.1",
 *                 },
 *                 NodeAgentSkuId = "batch.node.ubuntu 18.04",
 *             },
 *         },
 *         PoolName = "testpool",
 *         ResourceGroupName = "default-azurebatch-japaneast",
 *         VmSize = "STANDARD_D4",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/batch/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := batch.NewPool(ctx, "pool", &batch.PoolArgs{
 * AccountName: pulumi.String("sampleacct"),
 * DeploymentConfiguration: batch.DeploymentConfigurationResponse{
 * VirtualMachineConfiguration: interface{}{
 * ImageReference: &batch.ImageReferenceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/networking-group/providers/Microsoft.Compute/galleries/testgallery/images/testimagedef/versions/0.0.1"),
 * },
 * NodeAgentSkuId: pulumi.String("batch.node.ubuntu 18.04"),
 * },
 * },
 * PoolName: pulumi.String("testpool"),
 * ResourceGroupName: pulumi.String("default-azurebatch-japaneast"),
 * VmSize: pulumi.String("STANDARD_D4"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.batch.Pool;
 * import com.pulumi.azurenative.batch.PoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pool = new Pool("pool", PoolArgs.builder()
 *             .accountName("sampleacct")
 *             .deploymentConfiguration(Map.of("virtualMachineConfiguration", Map.ofEntries(
 *                 Map.entry("imageReference", Map.of("id", "/subscriptions/subid/resourceGroups/networking-group/providers/Microsoft.Compute/galleries/testgallery/images/testimagedef/versions/0.0.1")),
 *                 Map.entry("nodeAgentSkuId", "batch.node.ubuntu 18.04")
 *             )))
 *             .poolName("testpool")
 *             .resourceGroupName("default-azurebatch-japaneast")
 *             .vmSize("STANDARD_D4")
 *             .build());
 *     }
 * }
 * ```
 * ### CreatePool - Full CloudServiceConfiguration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pool = new AzureNative.Batch.Pool("pool", new()
 *     {
 *         AccountName = "sampleacct",
 *         ApplicationLicenses = new[]
 *         {
 *             "app-license0",
 *             "app-license1",
 *         },
 *         ApplicationPackages = new[]
 *         {
 *             new AzureNative.Batch.Inputs.ApplicationPackageReferenceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Batch/batchAccounts/sampleacct/pools/testpool/applications/app_1234",
 *                 Version = "asdf",
 *             },
 *         },
 *         Certificates = new[]
 *         {
 *             new AzureNative.Batch.Inputs.CertificateReferenceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Batch/batchAccounts/sampleacct/pools/testpool/certificates/sha1-1234567",
 *                 StoreLocation = AzureNative.Batch.CertificateStoreLocation.LocalMachine,
 *                 StoreName = "MY",
 *                 Visibility = new[]
 *                 {
 *                     AzureNative.Batch.CertificateVisibility.RemoteUser,
 *                 },
 *             },
 *         },
 *         DeploymentConfiguration = new AzureNative.Batch.Inputs.DeploymentConfigurationArgs
 *         {
 *             CloudServiceConfiguration = new AzureNative.Batch.Inputs.CloudServiceConfigurationArgs
 *             {
 *                 OsFamily = "4",
 *                 OsVersion = "WA-GUEST-OS-4.45_201708-01",
 *             },
 *         },
 *         DisplayName = "my-pool-name",
 *         InterNodeCommunication = AzureNative.Batch.InterNodeCommunicationState.Enabled,
 *         Metadata = new[]
 *         {
 *             new AzureNative.Batch.Inputs.MetadataItemArgs
 *             {
 *                 Name = "metadata-1",
 *                 Value = "value-1",
 *             },
 *             new AzureNative.Batch.Inputs.MetadataItemArgs
 *             {
 *                 Name = "metadata-2",
 *                 Value = "value-2",
 *             },
 *         },
 *         NetworkConfiguration = new AzureNative.Batch.Inputs.NetworkConfigurationArgs
 *         {
 *             PublicIPAddressConfiguration = new AzureNative.Batch.Inputs.PublicIPAddressConfigurationArgs
 *             {
 *                 IpAddressIds = new[]
 *                 {
 *                     "/subscriptions/subid1/resourceGroups/rg13/providers/Microsoft.Network/publicIPAddresses/ip135",
 *                     "/subscriptions/subid2/resourceGroups/rg24/providers/Microsoft.Network/publicIPAddresses/ip268",
 *                 },
 *                 Provision = AzureNative.Batch.IPAddressProvisioningType.UserManaged,
 *             },
 *             SubnetId = "/subscriptions/subid/resourceGroups/rg1234/providers/Microsoft.Network/virtualNetworks/network1234/subnets/subnet123",
 *         },
 *         PoolName = "testpool",
 *         ResourceGroupName = "default-azurebatch-japaneast",
 *         ScaleSettings = new AzureNative.Batch.Inputs.ScaleSettingsArgs
 *         {
 *             FixedScale = new AzureNative.Batch.Inputs.FixedScaleSettingsArgs
 *             {
 *                 NodeDeallocationOption = AzureNative.Batch.ComputeNodeDeallocationOption.TaskCompletion,
 *                 ResizeTimeout = "PT8M",
 *                 TargetDedicatedNodes = 6,
 *                 TargetLowPriorityNodes = 28,
 *             },
 *         },
 *         StartTask = new AzureNative.Batch.Inputs.StartTaskArgs
 *         {
 *             CommandLine = "cmd /c SET",
 *             EnvironmentSettings = new[]
 *             {
 *                 new AzureNative.Batch.Inputs.EnvironmentSettingArgs
 *                 {
 *                     Name = "MYSET",
 *                     Value = "1234",
 *                 },
 *             },
 *             MaxTaskRetryCount = 6,
 *             ResourceFiles = new[]
 *             {
 *                 new AzureNative.Batch.Inputs.ResourceFileArgs
 *                 {
 *                     FileMode = "777",
 *                     FilePath = "c:\\temp\\gohere",
 *                     HttpUrl = "https://testaccount.blob.core.windows.net/example-blob-file",
 *                 },
 *             },
 *             UserIdentity = new AzureNative.Batch.Inputs.UserIdentityArgs
 *             {
 *                 AutoUser = new AzureNative.Batch.Inputs.AutoUserSpecificationArgs
 *                 {
 *                     ElevationLevel = AzureNative.Batch.ElevationLevel.Admin,
 *                     Scope = AzureNative.Batch.AutoUserScope.Pool,
 *                 },
 *             },
 *             WaitForSuccess = true,
 *         },
 *         TaskSchedulingPolicy = new AzureNative.Batch.Inputs.TaskSchedulingPolicyArgs
 *         {
 *             NodeFillType = AzureNative.Batch.ComputeNodeFillType.Pack,
 *         },
 *         TaskSlotsPerNode = 13,
 *         UserAccounts = new[]
 *         {
 *             new AzureNative.Batch.Inputs.UserAccountArgs
 *             {
 *                 ElevationLevel = AzureNative.Batch.ElevationLevel.Admin,
 *                 LinuxUserConfiguration = new AzureNative.Batch.Inputs.LinuxUserConfigurationArgs
 *                 {
 *                     Gid = 4567,
 *                     SshPrivateKey = "sshprivatekeyvalue",
 *                     Uid = 1234,
 *                 },
 *                 Name = "username1",
 *                 Password = "<ExamplePassword>",
 *             },
 *         },
 *         VmSize = "STANDARD_D4",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/batch/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := batch.NewPool(ctx, "pool", &batch.PoolArgs{
 * AccountName: pulumi.String("sampleacct"),
 * ApplicationLicenses: pulumi.StringArray{
 * pulumi.String("app-license0"),
 * pulumi.String("app-license1"),
 * },
 * ApplicationPackages: []batch.ApplicationPackageReferenceArgs{
 * {
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Batch/batchAccounts/sampleacct/pools/testpool/applications/app_1234"),
 * Version: pulumi.String("asdf"),
 * },
 * },
 * Certificates: []batch.CertificateReferenceArgs{
 * {
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Batch/batchAccounts/sampleacct/pools/testpool/certificates/sha1-1234567"),
 * StoreLocation: batch.CertificateStoreLocationLocalMachine,
 * StoreName: pulumi.String("MY"),
 * Visibility: batch.CertificateVisibilityArray{
 * batch.CertificateVisibilityRemoteUser,
 * },
 * },
 * },
 * DeploymentConfiguration: batch.DeploymentConfigurationResponse{
 * CloudServiceConfiguration: &batch.CloudServiceConfigurationArgs{
 * OsFamily: pulumi.String("4"),
 * OsVersion: pulumi.String("WA-GUEST-OS-4.45_201708-01"),
 * },
 * },
 * DisplayName: pulumi.String("my-pool-name"),
 * InterNodeCommunication: batch.InterNodeCommunicationStateEnabled,
 * Metadata: []batch.MetadataItemArgs{
 * {
 * Name: pulumi.String("metadata-1"),
 * Value: pulumi.String("value-1"),
 * },
 * {
 * Name: pulumi.String("metadata-2"),
 * Value: pulumi.String("value-2"),
 * },
 * },
 * NetworkConfiguration: batch.NetworkConfigurationResponse{
 * PublicIPAddressConfiguration: &batch.PublicIPAddressConfigurationArgs{
 * IpAddressIds: pulumi.StringArray{
 * pulumi.String("/subscriptions/subid1/resourceGroups/rg13/providers/Microsoft.Network/publicIPAddresses/ip135"),
 * pulumi.String("/subscriptions/subid2/resourceGroups/rg24/providers/Microsoft.Network/publicIPAddresses/ip268"),
 * },
 * Provision: batch.IPAddressProvisioningTypeUserManaged,
 * },
 * SubnetId: pulumi.String("/subscriptions/subid/resourceGroups/rg1234/providers/Microsoft.Network/virtualNetworks/network1234/subnets/subnet123"),
 * },
 * PoolName: pulumi.String("testpool"),
 * ResourceGroupName: pulumi.String("default-azurebatch-japaneast"),
 * ScaleSettings: batch.ScaleSettingsResponse{
 * FixedScale: &batch.FixedScaleSettingsArgs{
 * NodeDeallocationOption: batch.ComputeNodeDeallocationOptionTaskCompletion,
 * ResizeTimeout: pulumi.String("PT8M"),
 * TargetDedicatedNodes: pulumi.Int(6),
 * TargetLowPriorityNodes: pulumi.Int(28),
 * },
 * },
 * StartTask: batch.StartTaskResponse{
 * CommandLine: pulumi.String("cmd /c SET"),
 * EnvironmentSettings: batch.EnvironmentSettingArray{
 * &batch.EnvironmentSettingArgs{
 * Name: pulumi.String("MYSET"),
 * Value: pulumi.String("1234"),
 * },
 * },
 * MaxTaskRetryCount: pulumi.Int(6),
 * ResourceFiles: batch.ResourceFileArray{
 * &batch.ResourceFileArgs{
 * FileMode: pulumi.String("777"),
 * FilePath: pulumi.String("c:\\temp\\gohere"),
 * HttpUrl: pulumi.String("https://testaccount.blob.core.windows.net/example-blob-file"),
 * },
 * },
 * UserIdentity: interface{}{
 * AutoUser: &batch.AutoUserSpecificationArgs{
 * ElevationLevel: batch.ElevationLevelAdmin,
 * Scope: batch.AutoUserScopePool,
 * },
 * },
 * WaitForSuccess: pulumi.Bool(true),
 * },
 * TaskSchedulingPolicy: &batch.TaskSchedulingPolicyArgs{
 * NodeFillType: batch.ComputeNodeFillTypePack,
 * },
 * TaskSlotsPerNode: pulumi.Int(13),
 * UserAccounts: []batch.UserAccountArgs{
 * {
 * ElevationLevel: batch.ElevationLevelAdmin,
 * LinuxUserConfiguration: {
 * Gid: pulumi.Int(4567),
 * SshPrivateKey: pulumi.String("sshprivatekeyvalue"),
 * Uid: pulumi.Int(1234),
 * },
 * Name: pulumi.String("username1"),
 * Password: pulumi.String("<ExamplePassword>"),
 * },
 * },
 * VmSize: pulumi.String("STANDARD_D4"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.batch.Pool;
 * import com.pulumi.azurenative.batch.PoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pool = new Pool("pool", PoolArgs.builder()
 *             .accountName("sampleacct")
 *             .applicationLicenses(
 *                 "app-license0",
 *                 "app-license1")
 *             .applicationPackages(Map.ofEntries(
 *                 Map.entry("id", "/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Batch/batchAccounts/sampleacct/pools/testpool/applications/app_1234"),
 *                 Map.entry("version", "asdf")
 *             ))
 *             .certificates(Map.ofEntries(
 *                 Map.entry("id", "/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Batch/batchAccounts/sampleacct/pools/testpool/certificates/sha1-1234567"),
 *                 Map.entry("storeLocation", "LocalMachine"),
 *                 Map.entry("storeName", "MY"),
 *                 Map.entry("visibility", "RemoteUser")
 *             ))
 *             .deploymentConfiguration(Map.of("cloudServiceConfiguration", Map.ofEntries(
 *                 Map.entry("osFamily", "4"),
 *                 Map.entry("osVersion", "WA-GUEST-OS-4.45_201708-01")
 *             )))
 *             .displayName("my-pool-name")
 *             .interNodeCommunication("Enabled")
 *             .metadata(
 *                 Map.ofEntries(
 *                     Map.entry("name", "metadata-1"),
 *                     Map.entry("value", "value-1")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("name", "metadata-2"),
 *                     Map.entry("value", "value-2")
 *                 ))
 *             .networkConfiguration(Map.ofEntries(
 *                 Map.entry("publicIPAddressConfiguration", Map.ofEntries(
 *                     Map.entry("ipAddressIds",
 *                         "/subscriptions/subid1/resourceGroups/rg13/providers/Microsoft.Network/publicIPAddresses/ip135",
 *                         "/subscriptions/subid2/resourceGroups/rg24/providers/Microsoft.Network/publicIPAddresses/ip268"),
 *                     Map.entry("provision", "UserManaged")
 *                 )),
 *                 Map.entry("subnetId", "/subscriptions/subid/resourceGroups/rg1234/providers/Microsoft.Network/virtualNetworks/network1234/subnets/subnet123")
 *             ))
 *             .poolName("testpool")
 *             .resourceGroupName("default-azurebatch-japaneast")
 *             .scaleSettings(Map.of("fixedScale", Map.ofEntries(
 *                 Map.entry("nodeDeallocationOption", "TaskCompletion"),
 *                 Map.entry("resizeTimeout", "PT8M"),
 *                 Map.entry("targetDedicatedNodes", 6),
 *                 Map.entry("targetLowPriorityNodes", 28)
 *             )))
 *             .startTask(Map.ofEntries(
 *                 Map.entry("commandLine", "cmd /c SET"),
 *                 Map.entry("environmentSettings", Map.ofEntries(
 *                     Map.entry("name", "MYSET"),
 *                     Map.entry("value", "1234")
 *                 )),
 *                 Map.entry("maxTaskRetryCount", 6),
 *                 Map.entry("resourceFiles", Map.ofEntries(
 *                     Map.entry("fileMode", "777"),
 *                     Map.entry("filePath", "c:\\temp\\gohere"),
 *                     Map.entry("httpUrl", "https://testaccount.blob.core.windows.net/example-blob-file")
 *                 )),
 *                 Map.entry("userIdentity", Map.of("autoUser", Map.ofEntries(
 *                     Map.entry("elevationLevel", "Admin"),
 *                     Map.entry("scope", "Pool")
 *                 ))),
 *                 Map.entry("waitForSuccess", true)
 *             ))
 *             .taskSchedulingPolicy(Map.of("nodeFillType", "Pack"))
 *             .taskSlotsPerNode(13)
 *             .userAccounts(Map.ofEntries(
 *                 Map.entry("elevationLevel", "Admin"),
 *                 Map.entry("linuxUserConfiguration", Map.ofEntries(
 *                     Map.entry("gid", 4567),
 *                     Map.entry("sshPrivateKey", "sshprivatekeyvalue"),
 *                     Map.entry("uid", 1234)
 *                 )),
 *                 Map.entry("name", "username1"),
 *                 Map.entry("password", "<ExamplePassword>")
 *             ))
 *             .vmSize("STANDARD_D4")
 *             .build());
 *     }
 * }
 * ```
 * ### CreatePool - Full VirtualMachineConfiguration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pool = new AzureNative.Batch.Pool("pool", new()
 *     {
 *         AccountName = "sampleacct",
 *         DeploymentConfiguration = new AzureNative.Batch.Inputs.DeploymentConfigurationArgs
 *         {
 *             VirtualMachineConfiguration = new AzureNative.Batch.Inputs.VirtualMachineConfigurationArgs
 *             {
 *                 DataDisks = new[]
 *                 {
 *                     new AzureNative.Batch.Inputs.DataDiskArgs
 *                     {
 *                         Caching = AzureNative.Batch.CachingType.ReadWrite,
 *                         DiskSizeGB = 30,
 *                         Lun = 0,
 *                         StorageAccountType = AzureNative.Batch.StorageAccountType.Premium_LRS,
 *                     },
 *                     new AzureNative.Batch.Inputs.DataDiskArgs
 *                     {
 *                         Caching = AzureNative.Batch.CachingType.None,
 *                         DiskSizeGB = 200,
 *                         Lun = 1,
 *                         StorageAccountType = AzureNative.Batch.StorageAccountType.Standard_LRS,
 *                     },
 *                 },
 *                 DiskEncryptionConfiguration = new AzureNative.Batch.Inputs.DiskEncryptionConfigurationArgs
 *                 {
 *                     Targets = new[]
 *                     {
 *                         AzureNative.Batch.DiskEncryptionTarget.OsDisk,
 *                         AzureNative.Batch.DiskEncryptionTarget.TemporaryDisk,
 *                     },
 *                 },
 *                 ImageReference = new AzureNative.Batch.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-Datacenter-SmallDisk",
 *                     Version = "latest",
 *                 },
 *                 LicenseType = "Windows_Server",
 *                 NodeAgentSkuId = "batch.node.windows amd64",
 *                 NodePlacementConfiguration = new AzureNative.Batch.Inputs.NodePlacementConfigurationArgs
 *                 {
 *                     Policy = AzureNative.Batch.NodePlacementPolicyType.Zonal,
 *                 },
 *                 OsDisk = new AzureNative.Batch.Inputs.OSDiskArgs
 *                 {
 *                     EphemeralOSDiskSettings = new AzureNative.Batch.Inputs.DiffDiskSettingsArgs
 *                     {
 *                         Placement = AzureNative.Batch.DiffDiskPlacement.CacheDisk,
 *                     },
 *                 },
 *                 WindowsConfiguration = new AzureNative.Batch.Inputs.WindowsConfigurationArgs
 *                 {
 *                     EnableAutomaticUpdates = false,
 *                 },
 *             },
 *         },
 *         NetworkConfiguration = new AzureNative.Batch.Inputs.NetworkConfigurationArgs
 *         {
 *             EndpointConfiguration = new AzureNative.Batch.Inputs.PoolEndpointConfigurationArgs
 *             {
 *                 InboundNatPools = new[]
 *                 {
 *                     new AzureNative.Batch.Inputs.InboundNatPoolArgs
 *                     {
 *                         BackendPort = 12001,
 *                         FrontendPortRangeEnd = 15100,
 *                         FrontendPortRangeStart = 15000,
 *                         Name = "testnat",
 *                         NetworkSecurityGroupRules = new[]
 *                         {
 *                             new AzureNative.Batch.Inputs.NetworkSecurityGroupRuleArgs
 *                             {
 *                                 Access = AzureNative.Batch.NetworkSecurityGroupRuleAccess.Allow,
 *                                 Priority = 150,
 *                                 SourceAddressPrefix = "192.100.12.45",
 *                                 SourcePortRanges = new[]
 *                                 {
 *                                     "1",
 *                                     "2",
 *                                 },
 *                             },
 *                             new AzureNative.Batch.Inputs.NetworkSecurityGroupRuleArgs
 *                             {
 *                                 Access = AzureNative.Batch.NetworkSecurityGroupRuleAccess.Deny,
 *                                 Priority = 3500,
 *                                 SourceAddressPrefix = "*",
 *                                 SourcePortRanges = new[]
 *                                 {
 *                                     "*",
 *                                 },
 *                             },
 *                         },
 *                         Protocol = AzureNative.Batch.InboundEndpointProtocol.TCP,
 *                     },
 *                 },
 *             },
 *         },
 *         PoolName = "testpool",
 *         ResourceGroupName = "default-azurebatch-japaneast",
 *         ScaleSettings = new AzureNative.Batch.Inputs.ScaleSettingsArgs
 *         {
 *             AutoScale = new AzureNative.Batch.Inputs.AutoScaleSettingsArgs
 *             {
 *                 EvaluationInterval = "PT5M",
 *                 Formula = "$TargetDedicatedNodes=1",
 *             },
 *         },
 *         VmSize = "STANDARD_D4",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/batch/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := batch.NewPool(ctx, "pool", &batch.PoolArgs{
 * AccountName: pulumi.String("sampleacct"),
 * DeploymentConfiguration: batch.DeploymentConfigurationResponse{
 * VirtualMachineConfiguration: interface{}{
 * DataDisks: batch.DataDiskArray{
 * &batch.DataDiskArgs{
 * Caching: batch.CachingTypeReadWrite,
 * DiskSizeGB: pulumi.Int(30),
 * Lun: pulumi.Int(0),
 * StorageAccountType: batch.StorageAccountType_Premium_LRS,
 * },
 * &batch.DataDiskArgs{
 * Caching: batch.CachingTypeNone,
 * DiskSizeGB: pulumi.Int(200),
 * Lun: pulumi.Int(1),
 * StorageAccountType: batch.StorageAccountType_Standard_LRS,
 * },
 * },
 * DiskEncryptionConfiguration: &batch.DiskEncryptionConfigurationArgs{
 * Targets: batch.DiskEncryptionTargetArray{
 * batch.DiskEncryptionTargetOsDisk,
 * batch.DiskEncryptionTargetTemporaryDisk,
 * },
 * },
 * ImageReference: &batch.ImageReferenceArgs{
 * Offer: pulumi.String("WindowsServer"),
 * Publisher: pulumi.String("MicrosoftWindowsServer"),
 * Sku: pulumi.String("2016-Datacenter-SmallDisk"),
 * Version: pulumi.String("latest"),
 * },
 * LicenseType: pulumi.String("Windows_Server"),
 * NodeAgentSkuId: pulumi.String("batch.node.windows amd64"),
 * NodePlacementConfiguration: &batch.NodePlacementConfigurationArgs{
 * Policy: batch.NodePlacementPolicyTypeZonal,
 * },
 * OsDisk: interface{}{
 * EphemeralOSDiskSettings: &batch.DiffDiskSettingsArgs{
 * Placement: batch.DiffDiskPlacementCacheDisk,
 * },
 * },
 * WindowsConfiguration: &batch.WindowsConfigurationArgs{
 * EnableAutomaticUpdates: pulumi.Bool(false),
 * },
 * },
 * },
 * NetworkConfiguration: batch.NetworkConfigurationResponse{
 * EndpointConfiguration: interface{}{
 * InboundNatPools: batch.InboundNatPoolArray{
 * interface{}{
 * BackendPort: pulumi.Int(12001),
 * FrontendPortRangeEnd: pulumi.Int(15100),
 * FrontendPortRangeStart: pulumi.Int(15000),
 * Name: pulumi.String("testnat"),
 * NetworkSecurityGroupRules: batch.NetworkSecurityGroupRuleArray{
 * &batch.NetworkSecurityGroupRuleArgs{
 * Access: batch.NetworkSecurityGroupRuleAccessAllow,
 * Priority: pulumi.Int(150),
 * SourceAddressPrefix: pulumi.String("192.100.12.45"),
 * SourcePortRanges: pulumi.StringArray{
 * pulumi.String("1"),
 * pulumi.String("2"),
 * },
 * },
 * &batch.NetworkSecurityGroupRuleArgs{
 * Access: batch.NetworkSecurityGroupRuleAccessDeny,
 * Priority: pulumi.Int(3500),
 * SourceAddressPrefix: pulumi.String("*"),
 * SourcePortRanges: pulumi.StringArray{
 * pulumi.String("*"),
 * },
 * },
 * },
 * Protocol: batch.InboundEndpointProtocolTCP,
 * },
 * },
 * },
 * },
 * PoolName: pulumi.String("testpool"),
 * ResourceGroupName: pulumi.String("default-azurebatch-japaneast"),
 * ScaleSettings: batch.ScaleSettingsResponse{
 * AutoScale: &batch.AutoScaleSettingsArgs{
 * EvaluationInterval: pulumi.String("PT5M"),
 * Formula: pulumi.String("$TargetDedicatedNodes=1"),
 * },
 * },
 * VmSize: pulumi.String("STANDARD_D4"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.batch.Pool;
 * import com.pulumi.azurenative.batch.PoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pool = new Pool("pool", PoolArgs.builder()
 *             .accountName("sampleacct")
 *             .deploymentConfiguration(Map.of("virtualMachineConfiguration", Map.ofEntries(
 *                 Map.entry("dataDisks",
 *                     Map.ofEntries(
 *                         Map.entry("caching", "ReadWrite"),
 *                         Map.entry("diskSizeGB", 30),
 *                         Map.entry("lun", 0),
 *                         Map.entry("storageAccountType", "Premium_LRS")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("caching", "None"),
 *                         Map.entry("diskSizeGB", 200),
 *                         Map.entry("lun", 1),
 *                         Map.entry("storageAccountType", "Standard_LRS")
 *                     )),
 *                 Map.entry("diskEncryptionConfiguration", Map.of("targets",
 *                     "OsDisk",
 *                     "TemporaryDisk")),
 *                 Map.entry("imageReference", Map.ofEntries(
 *                     Map.entry("offer", "WindowsServer"),
 *                     Map.entry("publisher", "MicrosoftWindowsServer"),
 *                     Map.entry("sku", "2016-Datacenter-SmallDisk"),
 *                     Map.entry("version", "latest")
 *                 )),
 *                 Map.entry("licenseType", "Windows_Server"),
 *                 Map.entry("nodeAgentSkuId", "batch.node.windows amd64"),
 *                 Map.entry("nodePlacementConfiguration", Map.of("policy", "Zonal")),
 *                 Map.entry("osDisk", Map.of("ephemeralOSDiskSettings", Map.of("placement", "CacheDisk"))),
 *                 Map.entry("windowsConfiguration", Map.of("enableAutomaticUpdates", false))
 *             )))
 *             .networkConfiguration(Map.of("endpointConfiguration", Map.of("inboundNatPools", Map.ofEntries(
 *                 Map.entry("backendPort", 12001),
 *                 Map.entry("frontendPortRangeEnd", 15100),
 *                 Map.entry("frontendPortRangeStart", 15000),
 *                 Map.entry("name", "testnat"),
 *                 Map.entry("networkSecurityGroupRules",
 *                     Map.ofEntries(
 *                         Map.entry("access", "Allow"),
 *                         Map.entry("priority", 150),
 *                         Map.entry("sourceAddressPrefix", "192.100.12.45"),
 *                         Map.entry("sourcePortRanges",
 *                             "1",
 *                             "2")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("access", "Deny"),
 *                         Map.entry("priority", 3500),
 *                         Map.entry("sourceAddressPrefix", "*"),
 *                         Map.entry("sourcePortRanges", "*")
 *                     )),
 *                 Map.entry("protocol", "TCP")
 *             ))))
 *             .poolName("testpool")
 *             .resourceGroupName("default-azurebatch-japaneast")
 *             .scaleSettings(Map.of("autoScale", Map.ofEntries(
 *                 Map.entry("evaluationInterval", "PT5M"),
 *                 Map.entry("formula", "$TargetDedicatedNodes=1")
 *             )))
 *             .vmSize("STANDARD_D4")
 *             .build());
 *     }
 * }
 * ```
 * ### CreatePool - Minimal CloudServiceConfiguration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pool = new AzureNative.Batch.Pool("pool", new()
 *     {
 *         AccountName = "sampleacct",
 *         DeploymentConfiguration = new AzureNative.Batch.Inputs.DeploymentConfigurationArgs
 *         {
 *             CloudServiceConfiguration = new AzureNative.Batch.Inputs.CloudServiceConfigurationArgs
 *             {
 *                 OsFamily = "5",
 *             },
 *         },
 *         PoolName = "testpool",
 *         ResourceGroupName = "default-azurebatch-japaneast",
 *         ScaleSettings = new AzureNative.Batch.Inputs.ScaleSettingsArgs
 *         {
 *             FixedScale = new AzureNative.Batch.Inputs.FixedScaleSettingsArgs
 *             {
 *                 TargetDedicatedNodes = 3,
 *             },
 *         },
 *         VmSize = "STANDARD_D4",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/batch/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := batch.NewPool(ctx, "pool", &batch.PoolArgs{
 * 			AccountName: pulumi.String("sampleacct"),
 * 			DeploymentConfiguration: batch.DeploymentConfigurationResponse{
 * 				CloudServiceConfiguration: &batch.CloudServiceConfigurationArgs{
 * 					OsFamily: pulumi.String("5"),
 * 				},
 * 			},
 * 			PoolName:          pulumi.String("testpool"),
 * 			ResourceGroupName: pulumi.String("default-azurebatch-japaneast"),
 * 			ScaleSettings: batch.ScaleSettingsResponse{
 * 				FixedScale: &batch.FixedScaleSettingsArgs{
 * 					TargetDedicatedNodes: pulumi.Int(3),
 * 				},
 * 			},
 * 			VmSize: pulumi.String("STANDARD_D4"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.batch.Pool;
 * import com.pulumi.azurenative.batch.PoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pool = new Pool("pool", PoolArgs.builder()
 *             .accountName("sampleacct")
 *             .deploymentConfiguration(Map.of("cloudServiceConfiguration", Map.of("osFamily", "5")))
 *             .poolName("testpool")
 *             .resourceGroupName("default-azurebatch-japaneast")
 *             .scaleSettings(Map.of("fixedScale", Map.of("targetDedicatedNodes", 3)))
 *             .vmSize("STANDARD_D4")
 *             .build());
 *     }
 * }
 * ```
 * ### CreatePool - Minimal VirtualMachineConfiguration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pool = new AzureNative.Batch.Pool("pool", new()
 *     {
 *         AccountName = "sampleacct",
 *         DeploymentConfiguration = new AzureNative.Batch.Inputs.DeploymentConfigurationArgs
 *         {
 *             VirtualMachineConfiguration = new AzureNative.Batch.Inputs.VirtualMachineConfigurationArgs
 *             {
 *                 ImageReference = new AzureNative.Batch.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "UbuntuServer",
 *                     Publisher = "Canonical",
 *                     Sku = "18.04-LTS",
 *                     Version = "latest",
 *                 },
 *                 NodeAgentSkuId = "batch.node.ubuntu 18.04",
 *             },
 *         },
 *         PoolName = "testpool",
 *         ResourceGroupName = "default-azurebatch-japaneast",
 *         ScaleSettings = new AzureNative.Batch.Inputs.ScaleSettingsArgs
 *         {
 *             AutoScale = new AzureNative.Batch.Inputs.AutoScaleSettingsArgs
 *             {
 *                 EvaluationInterval = "PT5M",
 *                 Formula = "$TargetDedicatedNodes=1",
 *             },
 *         },
 *         VmSize = "STANDARD_D4",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/batch/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := batch.NewPool(ctx, "pool", &batch.PoolArgs{
 * AccountName: pulumi.String("sampleacct"),
 * DeploymentConfiguration: batch.DeploymentConfigurationResponse{
 * VirtualMachineConfiguration: interface{}{
 * ImageReference: &batch.ImageReferenceArgs{
 * Offer: pulumi.String("UbuntuServer"),
 * Publisher: pulumi.String("Canonical"),
 * Sku: pulumi.String("18.04-LTS"),
 * Version: pulumi.String("latest"),
 * },
 * NodeAgentSkuId: pulumi.String("batch.node.ubuntu 18.04"),
 * },
 * },
 * PoolName: pulumi.String("testpool"),
 * ResourceGroupName: pulumi.String("default-azurebatch-japaneast"),
 * ScaleSettings: batch.ScaleSettingsResponse{
 * AutoScale: &batch.AutoScaleSettingsArgs{
 * EvaluationInterval: pulumi.String("PT5M"),
 * Formula: pulumi.String("$TargetDedicatedNodes=1"),
 * },
 * },
 * VmSize: pulumi.String("STANDARD_D4"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.batch.Pool;
 * import com.pulumi.azurenative.batch.PoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pool = new Pool("pool", PoolArgs.builder()
 *             .accountName("sampleacct")
 *             .deploymentConfiguration(Map.of("virtualMachineConfiguration", Map.ofEntries(
 *                 Map.entry("imageReference", Map.ofEntries(
 *                     Map.entry("offer", "UbuntuServer"),
 *                     Map.entry("publisher", "Canonical"),
 *                     Map.entry("sku", "18.04-LTS"),
 *                     Map.entry("version", "latest")
 *                 )),
 *                 Map.entry("nodeAgentSkuId", "batch.node.ubuntu 18.04")
 *             )))
 *             .poolName("testpool")
 *             .resourceGroupName("default-azurebatch-japaneast")
 *             .scaleSettings(Map.of("autoScale", Map.ofEntries(
 *                 Map.entry("evaluationInterval", "PT5M"),
 *                 Map.entry("formula", "$TargetDedicatedNodes=1")
 *             )))
 *             .vmSize("STANDARD_D4")
 *             .build());
 *     }
 * }
 * ```
 * ### CreatePool - No public IP
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pool = new AzureNative.Batch.Pool("pool", new()
 *     {
 *         AccountName = "sampleacct",
 *         DeploymentConfiguration = new AzureNative.Batch.Inputs.DeploymentConfigurationArgs
 *         {
 *             VirtualMachineConfiguration = new AzureNative.Batch.Inputs.VirtualMachineConfigurationArgs
 *             {
 *                 ImageReference = new AzureNative.Batch.Inputs.ImageReferenceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/networking-group/providers/Microsoft.Compute/galleries/testgallery/images/testimagedef/versions/0.0.1",
 *                 },
 *                 NodeAgentSkuId = "batch.node.ubuntu 18.04",
 *             },
 *         },
 *         NetworkConfiguration = new AzureNative.Batch.Inputs.NetworkConfigurationArgs
 *         {
 *             PublicIPAddressConfiguration = new AzureNative.Batch.Inputs.PublicIPAddressConfigurationArgs
 *             {
 *                 Provision = AzureNative.Batch.IPAddressProvisioningType.NoPublicIPAddresses,
 *             },
 *             SubnetId = "/subscriptions/subid/resourceGroups/rg1234/providers/Microsoft.Network/virtualNetworks/network1234/subnets/subnet123",
 *         },
 *         PoolName = "testpool",
 *         ResourceGroupName = "default-azurebatch-japaneast",
 *         VmSize = "STANDARD_D4",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/batch/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := batch.NewPool(ctx, "pool", &batch.PoolArgs{
 * AccountName: pulumi.String("sampleacct"),
 * DeploymentConfiguration: batch.DeploymentConfigurationResponse{
 * VirtualMachineConfiguration: interface{}{
 * ImageReference: &batch.ImageReferenceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/networking-group/providers/Microsoft.Compute/galleries/testgallery/images/testimagedef/versions/0.0.1"),
 * },
 * NodeAgentSkuId: pulumi.String("batch.node.ubuntu 18.04"),
 * },
 * },
 * NetworkConfiguration: batch.NetworkConfigurationResponse{
 * PublicIPAddressConfiguration: &batch.PublicIPAddressConfigurationArgs{
 * Provision: batch.IPAddressProvisioningTypeNoPublicIPAddresses,
 * },
 * SubnetId: pulumi.String("/subscriptions/subid/resourceGroups/rg1234/providers/Microsoft.Network/virtualNetworks/network1234/subnets/subnet123"),
 * },
 * PoolName: pulumi.String("testpool"),
 * ResourceGroupName: pulumi.String("default-azurebatch-japaneast"),
 * VmSize: pulumi.String("STANDARD_D4"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.batch.Pool;
 * import com.pulumi.azurenative.batch.PoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pool = new Pool("pool", PoolArgs.builder()
 *             .accountName("sampleacct")
 *             .deploymentConfiguration(Map.of("virtualMachineConfiguration", Map.ofEntries(
 *                 Map.entry("imageReference", Map.of("id", "/subscriptions/subid/resourceGroups/networking-group/providers/Microsoft.Compute/galleries/testgallery/images/testimagedef/versions/0.0.1")),
 *                 Map.entry("nodeAgentSkuId", "batch.node.ubuntu 18.04")
 *             )))
 *             .networkConfiguration(Map.ofEntries(
 *                 Map.entry("publicIPAddressConfiguration", Map.of("provision", "NoPublicIPAddresses")),
 *                 Map.entry("subnetId", "/subscriptions/subid/resourceGroups/rg1234/providers/Microsoft.Network/virtualNetworks/network1234/subnets/subnet123")
 *             ))
 *             .poolName("testpool")
 *             .resourceGroupName("default-azurebatch-japaneast")
 *             .vmSize("STANDARD_D4")
 *             .build());
 *     }
 * }
 * ```
 * ### CreatePool - Public IPs
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pool = new AzureNative.Batch.Pool("pool", new()
 *     {
 *         AccountName = "sampleacct",
 *         DeploymentConfiguration = new AzureNative.Batch.Inputs.DeploymentConfigurationArgs
 *         {
 *             VirtualMachineConfiguration = new AzureNative.Batch.Inputs.VirtualMachineConfigurationArgs
 *             {
 *                 ImageReference = new AzureNative.Batch.Inputs.ImageReferenceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/networking-group/providers/Microsoft.Compute/galleries/testgallery/images/testimagedef/versions/0.0.1",
 *                 },
 *                 NodeAgentSkuId = "batch.node.ubuntu 18.04",
 *             },
 *         },
 *         NetworkConfiguration = new AzureNative.Batch.Inputs.NetworkConfigurationArgs
 *         {
 *             PublicIPAddressConfiguration = new AzureNative.Batch.Inputs.PublicIPAddressConfigurationArgs
 *             {
 *                 IpAddressIds = new[]
 *                 {
 *                     "/subscriptions/subid1/resourceGroups/rg13/providers/Microsoft.Network/publicIPAddresses/ip135",
 *                 },
 *                 Provision = AzureNative.Batch.IPAddressProvisioningType.UserManaged,
 *             },
 *             SubnetId = "/subscriptions/subid/resourceGroups/rg1234/providers/Microsoft.Network/virtualNetworks/network1234/subnets/subnet123",
 *         },
 *         PoolName = "testpool",
 *         ResourceGroupName = "default-azurebatch-japaneast",
 *         VmSize = "STANDARD_D4",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/batch/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := batch.NewPool(ctx, "pool", &batch.PoolArgs{
 * AccountName: pulumi.String("sampleacct"),
 * DeploymentConfiguration: batch.DeploymentConfigurationResponse{
 * VirtualMachineConfiguration: interface{}{
 * ImageReference: &batch.ImageReferenceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/networking-group/providers/Microsoft.Compute/galleries/testgallery/images/testimagedef/versions/0.0.1"),
 * },
 * NodeAgentSkuId: pulumi.String("batch.node.ubuntu 18.04"),
 * },
 * },
 * NetworkConfiguration: batch.NetworkConfigurationResponse{
 * PublicIPAddressConfiguration: &batch.PublicIPAddressConfigurationArgs{
 * IpAddressIds: pulumi.StringArray{
 * pulumi.String("/subscriptions/subid1/resourceGroups/rg13/providers/Microsoft.Network/publicIPAddresses/ip135"),
 * },
 * Provision: batch.IPAddressProvisioningTypeUserManaged,
 * },
 * SubnetId: pulumi.String("/subscriptions/subid/resourceGroups/rg1234/providers/Microsoft.Network/virtualNetworks/network1234/subnets/subnet123"),
 * },
 * PoolName: pulumi.String("testpool"),
 * ResourceGroupName: pulumi.String("default-azurebatch-japaneast"),
 * VmSize: pulumi.String("STANDARD_D4"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.batch.Pool;
 * import com.pulumi.azurenative.batch.PoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pool = new Pool("pool", PoolArgs.builder()
 *             .accountName("sampleacct")
 *             .deploymentConfiguration(Map.of("virtualMachineConfiguration", Map.ofEntries(
 *                 Map.entry("imageReference", Map.of("id", "/subscriptions/subid/resourceGroups/networking-group/providers/Microsoft.Compute/galleries/testgallery/images/testimagedef/versions/0.0.1")),
 *                 Map.entry("nodeAgentSkuId", "batch.node.ubuntu 18.04")
 *             )))
 *             .networkConfiguration(Map.ofEntries(
 *                 Map.entry("publicIPAddressConfiguration", Map.ofEntries(
 *                     Map.entry("ipAddressIds", "/subscriptions/subid1/resourceGroups/rg13/providers/Microsoft.Network/publicIPAddresses/ip135"),
 *                     Map.entry("provision", "UserManaged")
 *                 )),
 *                 Map.entry("subnetId", "/subscriptions/subid/resourceGroups/rg1234/providers/Microsoft.Network/virtualNetworks/network1234/subnets/subnet123")
 *             ))
 *             .poolName("testpool")
 *             .resourceGroupName("default-azurebatch-japaneast")
 *             .vmSize("STANDARD_D4")
 *             .build());
 *     }
 * }
 * ```
 * ### CreatePool - VirtualMachineConfiguration Extensions
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pool = new AzureNative.Batch.Pool("pool", new()
 *     {
 *         AccountName = "sampleacct",
 *         DeploymentConfiguration = new AzureNative.Batch.Inputs.DeploymentConfigurationArgs
 *         {
 *             VirtualMachineConfiguration = new AzureNative.Batch.Inputs.VirtualMachineConfigurationArgs
 *             {
 *                 Extensions = new[]
 *                 {
 *                     new AzureNative.Batch.Inputs.VMExtensionArgs
 *                     {
 *                         AutoUpgradeMinorVersion = true,
 *                         EnableAutomaticUpgrade = true,
 *                         Name = "batchextension1",
 *                         Publisher = "Microsoft.Azure.KeyVault",
 *                         Settings =
 *                         {
 *                             { "authenticationSettingsKey", "authenticationSettingsValue" },
 *                             { "secretsManagementSettingsKey", "secretsManagementSettingsValue" },
 *                         },
 *                         Type = "KeyVaultForLinux",
 *                         TypeHandlerVersion = "2.0",
 *                     },
 *                 },
 *                 ImageReference = new AzureNative.Batch.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "0001-com-ubuntu-server-focal",
 *                     Publisher = "Canonical",
 *                     Sku = "20_04-lts",
 *                 },
 *                 NodeAgentSkuId = "batch.node.ubuntu 20.04",
 *             },
 *         },
 *         PoolName = "testpool",
 *         ResourceGroupName = "default-azurebatch-japaneast",
 *         ScaleSettings = new AzureNative.Batch.Inputs.ScaleSettingsArgs
 *         {
 *             AutoScale = new AzureNative.Batch.Inputs.AutoScaleSettingsArgs
 *             {
 *                 EvaluationInterval = "PT5M",
 *                 Formula = "$TargetDedicatedNodes=1",
 *             },
 *         },
 *         TargetNodeCommunicationMode = AzureNative.Batch.NodeCommunicationMode.Default,
 *         VmSize = "STANDARD_D4",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/batch/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := batch.NewPool(ctx, "pool", &batch.PoolArgs{
 * AccountName: pulumi.String("sampleacct"),
 * DeploymentConfiguration: batch.DeploymentConfigurationResponse{
 * VirtualMachineConfiguration: interface{}{
 * Extensions: batch.VMExtensionArray{
 * &batch.VMExtensionArgs{
 * AutoUpgradeMinorVersion: pulumi.Bool(true),
 * EnableAutomaticUpgrade: pulumi.Bool(true),
 * Name: pulumi.String("batchextension1"),
 * Publisher: pulumi.String("Microsoft.Azure.KeyVault"),
 * Settings: pulumi.Any{
 * AuthenticationSettingsKey: "authenticationSettingsValue",
 * SecretsManagementSettingsKey: "secretsManagementSettingsValue",
 * },
 * Type: pulumi.String("KeyVaultForLinux"),
 * TypeHandlerVersion: pulumi.String("2.0"),
 * },
 * },
 * ImageReference: &batch.ImageReferenceArgs{
 * Offer: pulumi.String("0001-com-ubuntu-server-focal"),
 * Publisher: pulumi.String("Canonical"),
 * Sku: pulumi.String("20_04-lts"),
 * },
 * NodeAgentSkuId: pulumi.String("batch.node.ubuntu 20.04"),
 * },
 * },
 * PoolName: pulumi.String("testpool"),
 * ResourceGroupName: pulumi.String("default-azurebatch-japaneast"),
 * ScaleSettings: batch.ScaleSettingsResponse{
 * AutoScale: &batch.AutoScaleSettingsArgs{
 * EvaluationInterval: pulumi.String("PT5M"),
 * Formula: pulumi.String("$TargetDedicatedNodes=1"),
 * },
 * },
 * TargetNodeCommunicationMode: batch.NodeCommunicationModeDefault,
 * VmSize: pulumi.String("STANDARD_D4"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.batch.Pool;
 * import com.pulumi.azurenative.batch.PoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pool = new Pool("pool", PoolArgs.builder()
 *             .accountName("sampleacct")
 *             .deploymentConfiguration(Map.of("virtualMachineConfiguration", Map.ofEntries(
 *                 Map.entry("extensions", Map.ofEntries(
 *                     Map.entry("autoUpgradeMinorVersion", true),
 *                     Map.entry("enableAutomaticUpgrade", true),
 *                     Map.entry("name", "batchextension1"),
 *                     Map.entry("publisher", "Microsoft.Azure.KeyVault"),
 *                     Map.entry("settings", Map.ofEntries(
 *                         Map.entry("authenticationSettingsKey", "authenticationSettingsValue"),
 *                         Map.entry("secretsManagementSettingsKey", "secretsManagementSettingsValue")
 *                     )),
 *                     Map.entry("type", "KeyVaultForLinux"),
 *                     Map.entry("typeHandlerVersion", "2.0")
 *                 )),
 *                 Map.entry("imageReference", Map.ofEntries(
 *                     Map.entry("offer", "0001-com-ubuntu-server-focal"),
 *                     Map.entry("publisher", "Canonical"),
 *                     Map.entry("sku", "20_04-lts")
 *                 )),
 *                 Map.entry("nodeAgentSkuId", "batch.node.ubuntu 20.04")
 *             )))
 *             .poolName("testpool")
 *             .resourceGroupName("default-azurebatch-japaneast")
 *             .scaleSettings(Map.of("autoScale", Map.ofEntries(
 *                 Map.entry("evaluationInterval", "PT5M"),
 *                 Map.entry("formula", "$TargetDedicatedNodes=1")
 *             )))
 *             .targetNodeCommunicationMode("Default")
 *             .vmSize("STANDARD_D4")
 *             .build());
 *     }
 * }
 * ```
 * ### CreatePool - accelerated networking
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pool = new AzureNative.Batch.Pool("pool", new()
 *     {
 *         AccountName = "sampleacct",
 *         DeploymentConfiguration = new AzureNative.Batch.Inputs.DeploymentConfigurationArgs
 *         {
 *             VirtualMachineConfiguration = new AzureNative.Batch.Inputs.VirtualMachineConfigurationArgs
 *             {
 *                 ImageReference = new AzureNative.Batch.Inputs.ImageReferenceArgs
 *                 {
 *                     Offer = "WindowsServer",
 *                     Publisher = "MicrosoftWindowsServer",
 *                     Sku = "2016-datacenter-smalldisk",
 *                     Version = "latest",
 *                 },
 *                 NodeAgentSkuId = "batch.node.windows amd64",
 *             },
 *         },
 *         NetworkConfiguration = new AzureNative.Batch.Inputs.NetworkConfigurationArgs
 *         {
 *             EnableAcceleratedNetworking = true,
 *             SubnetId = "/subscriptions/subid/resourceGroups/rg1234/providers/Microsoft.Network/virtualNetworks/network1234/subnets/subnet123",
 *         },
 *         PoolName = "testpool",
 *         ResourceGroupName = "default-azurebatch-japaneast",
 *         ScaleSettings = new AzureNative.Batch.Inputs.ScaleSettingsArgs
 *         {
 *             FixedScale = new AzureNative.Batch.Inputs.FixedScaleSettingsArgs
 *             {
 *                 TargetDedicatedNodes = 1,
 *                 TargetLowPriorityNodes = 0,
 *             },
 *         },
 *         VmSize = "STANDARD_D1_V2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/batch/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := batch.NewPool(ctx, "pool", &batch.PoolArgs{
 * AccountName: pulumi.String("sampleacct"),
 * DeploymentConfiguration: batch.DeploymentConfigurationResponse{
 * VirtualMachineConfiguration: interface{}{
 * ImageReference: &batch.ImageReferenceArgs{
 * Offer: pulumi.String("WindowsServer"),
 * Publisher: pulumi.String("MicrosoftWindowsServer"),
 * Sku: pulumi.String("2016-datacenter-smalldisk"),
 * Version: pulumi.String("latest"),
 * },
 * NodeAgentSkuId: pulumi.String("batch.node.windows amd64"),
 * },
 * },
 * NetworkConfiguration: &batch.NetworkConfigurationArgs{
 * EnableAcceleratedNetworking: pulumi.Bool(true),
 * SubnetId: pulumi.String("/subscriptions/subid/resourceGroups/rg1234/providers/Microsoft.Network/virtualNetworks/network1234/subnets/subnet123"),
 * },
 * PoolName: pulumi.String("testpool"),
 * ResourceGroupName: pulumi.String("default-azurebatch-japaneast"),
 * ScaleSettings: batch.ScaleSettingsResponse{
 * FixedScale: &batch.FixedScaleSettingsArgs{
 * TargetDedicatedNodes: pulumi.Int(1),
 * TargetLowPriorityNodes: pulumi.Int(0),
 * },
 * },
 * VmSize: pulumi.String("STANDARD_D1_V2"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.batch.Pool;
 * import com.pulumi.azurenative.batch.PoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pool = new Pool("pool", PoolArgs.builder()
 *             .accountName("sampleacct")
 *             .deploymentConfiguration(Map.of("virtualMachineConfiguration", Map.ofEntries(
 *                 Map.entry("imageReference", Map.ofEntries(
 *                     Map.entry("offer", "WindowsServer"),
 *                     Map.entry("publisher", "MicrosoftWindowsServer"),
 *                     Map.entry("sku", "2016-datacenter-smalldisk"),
 *                     Map.entry("version", "latest")
 *                 )),
 *                 Map.entry("nodeAgentSkuId", "batch.node.windows amd64")
 *             )))
 *             .networkConfiguration(Map.ofEntries(
 *                 Map.entry("enableAcceleratedNetworking", true),
 *                 Map.entry("subnetId", "/subscriptions/subid/resourceGroups/rg1234/providers/Microsoft.Network/virtualNetworks/network1234/subnets/subnet123")
 *             ))
 *             .poolName("testpool")
 *             .resourceGroupName("default-azurebatch-japaneast")
 *             .scaleSettings(Map.of("fixedScale", Map.ofEntries(
 *                 Map.entry("targetDedicatedNodes", 1),
 *                 Map.entry("targetLowPriorityNodes", 0)
 *             )))
 *             .vmSize("STANDARD_D1_V2")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:batch:Pool testpool /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/pools/{poolName}
 * ```
 * @property accountName The name of the Batch account.
 * @property applicationLicenses The list of application licenses must be a subset of available Batch service application licenses. If a license is requested which is not supported, pool creation will fail.
 * @property applicationPackages Changes to application package references affect all new compute nodes joining the pool, but do not affect compute nodes that are already in the pool until they are rebooted or reimaged. There is a maximum of 10 application package references on any given pool.
 * @property certificates For Windows compute nodes, the Batch service installs the certificates to the specified certificate store and location. For Linux compute nodes, the certificates are stored in a directory inside the task working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this location. For certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's home directory (e.g., /home/{user-name}/certs) and certificates are placed in that directory.
 * Warning: This property is deprecated and will be removed after February, 2024. Please use the [Azure KeyVault Extension](https://learn.microsoft.com/azure/batch/batch-certificate-migration-guide) instead.
 * @property deploymentConfiguration Using CloudServiceConfiguration specifies that the nodes should be creating using Azure Cloud Services (PaaS), while VirtualMachineConfiguration uses Azure Virtual Machines (IaaS).
 * @property displayName The display name need not be unique and can contain any Unicode characters up to a maximum length of 1024.
 * @property identity The type of identity used for the Batch Pool.
 * @property interNodeCommunication This imposes restrictions on which nodes can be assigned to the pool. Enabling this value can reduce the chance of the requested number of nodes to be allocated in the pool. If not specified, this value defaults to 'Disabled'.
 * @property metadata The Batch service does not assign any meaning to metadata; it is solely for the use of user code.
 * @property mountConfiguration This supports Azure Files, NFS, CIFS/SMB, and Blobfuse.
 * @property networkConfiguration The network configuration for a pool.
 * @property poolName The pool name. This must be unique within the account.
 * @property resourceGroupName The name of the resource group that contains the Batch account.
 * @property scaleSettings Defines the desired size of the pool. This can either be 'fixedScale' where the requested targetDedicatedNodes is specified, or 'autoScale' which defines a formula which is periodically reevaluated. If this property is not specified, the pool will have a fixed scale with 0 targetDedicatedNodes.
 * @property startTask In an PATCH (update) operation, this property can be set to an empty object to remove the start task from the pool.
 * @property targetNodeCommunicationMode If omitted, the default value is Default.
 * @property taskSchedulingPolicy If not specified, the default is spread.
 * @property taskSlotsPerNode The default value is 1. The maximum value is the smaller of 4 times the number of cores of the vmSize of the pool or 256.
 * @property userAccounts
 * @property vmSize For information about available sizes of virtual machines for Cloud Services pools (pools created with cloudServiceConfiguration), see Sizes for Cloud Services (https://azure.microsoft.com/documentation/articles/cloud-services-sizes-specs/). Batch supports all Cloud Services VM sizes except ExtraSmall. For information about available VM sizes for pools using images from the Virtual Machines Marketplace (pools created with virtualMachineConfiguration) see Sizes for Virtual Machines (Linux) (https://azure.microsoft.com/documentation/articles/virtual-machines-linux-sizes/) or Sizes for Virtual Machines (Windows) (https://azure.microsoft.com/documentation/articles/virtual-machines-windows-sizes/). Batch supports all Azure VM sizes except STANDARD_A0 and those with premium storage (STANDARD_GS, STANDARD_DS, and STANDARD_DSV2 series).
 */
public data class PoolArgs(
    public val accountName: Output<String>? = null,
    public val applicationLicenses: Output<List<String>>? = null,
    public val applicationPackages: Output<List<ApplicationPackageReferenceArgs>>? = null,
    public val certificates: Output<List<CertificateReferenceArgs>>? = null,
    public val deploymentConfiguration: Output<DeploymentConfigurationArgs>? = null,
    public val displayName: Output<String>? = null,
    public val identity: Output<BatchPoolIdentityArgs>? = null,
    public val interNodeCommunication: Output<InterNodeCommunicationState>? = null,
    public val metadata: Output<List<MetadataItemArgs>>? = null,
    public val mountConfiguration: Output<List<MountConfigurationArgs>>? = null,
    public val networkConfiguration: Output<NetworkConfigurationArgs>? = null,
    public val poolName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scaleSettings: Output<ScaleSettingsArgs>? = null,
    public val startTask: Output<StartTaskArgs>? = null,
    public val targetNodeCommunicationMode: Output<NodeCommunicationMode>? = null,
    public val taskSchedulingPolicy: Output<TaskSchedulingPolicyArgs>? = null,
    public val taskSlotsPerNode: Output<Int>? = null,
    public val userAccounts: Output<List<UserAccountArgs>>? = null,
    public val vmSize: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.batch.PoolArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.PoolArgs =
        com.pulumi.azurenative.batch.PoolArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .applicationLicenses(applicationLicenses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .applicationPackages(
                applicationPackages?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .certificates(
                certificates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .deploymentConfiguration(
                deploymentConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .interNodeCommunication(
                interNodeCommunication?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .metadata(
                metadata?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .mountConfiguration(
                mountConfiguration?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .networkConfiguration(
                networkConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .poolName(poolName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scaleSettings(scaleSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .startTask(startTask?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .targetNodeCommunicationMode(
                targetNodeCommunicationMode?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .taskSchedulingPolicy(
                taskSchedulingPolicy?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .taskSlotsPerNode(taskSlotsPerNode?.applyValue({ args0 -> args0 }))
            .userAccounts(
                userAccounts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .vmSize(vmSize?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PoolArgs].
 */
@PulumiTagMarker
public class PoolArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var applicationLicenses: Output<List<String>>? = null

    private var applicationPackages: Output<List<ApplicationPackageReferenceArgs>>? = null

    private var certificates: Output<List<CertificateReferenceArgs>>? = null

    private var deploymentConfiguration: Output<DeploymentConfigurationArgs>? = null

    private var displayName: Output<String>? = null

    private var identity: Output<BatchPoolIdentityArgs>? = null

    private var interNodeCommunication: Output<InterNodeCommunicationState>? = null

    private var metadata: Output<List<MetadataItemArgs>>? = null

    private var mountConfiguration: Output<List<MountConfigurationArgs>>? = null

    private var networkConfiguration: Output<NetworkConfigurationArgs>? = null

    private var poolName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var scaleSettings: Output<ScaleSettingsArgs>? = null

    private var startTask: Output<StartTaskArgs>? = null

    private var targetNodeCommunicationMode: Output<NodeCommunicationMode>? = null

    private var taskSchedulingPolicy: Output<TaskSchedulingPolicyArgs>? = null

    private var taskSlotsPerNode: Output<Int>? = null

    private var userAccounts: Output<List<UserAccountArgs>>? = null

    private var vmSize: Output<String>? = null

    /**
     * @param value The name of the Batch account.
     */
    @JvmName("vvhnnmsyguwxiylh")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The list of application licenses must be a subset of available Batch service application licenses. If a license is requested which is not supported, pool creation will fail.
     */
    @JvmName("uxccrlheaexihuvm")
    public suspend fun applicationLicenses(`value`: Output<List<String>>) {
        this.applicationLicenses = value
    }

    @JvmName("lhwflftdtueavqls")
    public suspend fun applicationLicenses(vararg values: Output<String>) {
        this.applicationLicenses = Output.all(values.asList())
    }

    /**
     * @param values The list of application licenses must be a subset of available Batch service application licenses. If a license is requested which is not supported, pool creation will fail.
     */
    @JvmName("novvwcbppxrpoqht")
    public suspend fun applicationLicenses(values: List<Output<String>>) {
        this.applicationLicenses = Output.all(values)
    }

    /**
     * @param value Changes to application package references affect all new compute nodes joining the pool, but do not affect compute nodes that are already in the pool until they are rebooted or reimaged. There is a maximum of 10 application package references on any given pool.
     */
    @JvmName("mtvmblxxdwygmcgv")
    public suspend fun applicationPackages(`value`: Output<List<ApplicationPackageReferenceArgs>>) {
        this.applicationPackages = value
    }

    @JvmName("pcrqmhhibwgxrpxg")
    public suspend fun applicationPackages(vararg values: Output<ApplicationPackageReferenceArgs>) {
        this.applicationPackages = Output.all(values.asList())
    }

    /**
     * @param values Changes to application package references affect all new compute nodes joining the pool, but do not affect compute nodes that are already in the pool until they are rebooted or reimaged. There is a maximum of 10 application package references on any given pool.
     */
    @JvmName("eqtvwlsdituhkkcc")
    public suspend fun applicationPackages(values: List<Output<ApplicationPackageReferenceArgs>>) {
        this.applicationPackages = Output.all(values)
    }

    /**
     * @param value For Windows compute nodes, the Batch service installs the certificates to the specified certificate store and location. For Linux compute nodes, the certificates are stored in a directory inside the task working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this location. For certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's home directory (e.g., /home/{user-name}/certs) and certificates are placed in that directory.
     * Warning: This property is deprecated and will be removed after February, 2024. Please use the [Azure KeyVault Extension](https://learn.microsoft.com/azure/batch/batch-certificate-migration-guide) instead.
     */
    @JvmName("bsivoumnkjnltuur")
    public suspend fun certificates(`value`: Output<List<CertificateReferenceArgs>>) {
        this.certificates = value
    }

    @JvmName("pubxritnjrqiqlan")
    public suspend fun certificates(vararg values: Output<CertificateReferenceArgs>) {
        this.certificates = Output.all(values.asList())
    }

    /**
     * @param values For Windows compute nodes, the Batch service installs the certificates to the specified certificate store and location. For Linux compute nodes, the certificates are stored in a directory inside the task working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this location. For certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's home directory (e.g., /home/{user-name}/certs) and certificates are placed in that directory.
     * Warning: This property is deprecated and will be removed after February, 2024. Please use the [Azure KeyVault Extension](https://learn.microsoft.com/azure/batch/batch-certificate-migration-guide) instead.
     */
    @JvmName("gcbdduxovogyieux")
    public suspend fun certificates(values: List<Output<CertificateReferenceArgs>>) {
        this.certificates = Output.all(values)
    }

    /**
     * @param value Using CloudServiceConfiguration specifies that the nodes should be creating using Azure Cloud Services (PaaS), while VirtualMachineConfiguration uses Azure Virtual Machines (IaaS).
     */
    @JvmName("ghqbrhinksphvqcd")
    public suspend fun deploymentConfiguration(`value`: Output<DeploymentConfigurationArgs>) {
        this.deploymentConfiguration = value
    }

    /**
     * @param value The display name need not be unique and can contain any Unicode characters up to a maximum length of 1024.
     */
    @JvmName("hkuyufbhhomolfpg")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The type of identity used for the Batch Pool.
     */
    @JvmName("kxudykykcqxlykcm")
    public suspend fun identity(`value`: Output<BatchPoolIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value This imposes restrictions on which nodes can be assigned to the pool. Enabling this value can reduce the chance of the requested number of nodes to be allocated in the pool. If not specified, this value defaults to 'Disabled'.
     */
    @JvmName("qabcvyafpbaoilef")
    public suspend fun interNodeCommunication(`value`: Output<InterNodeCommunicationState>) {
        this.interNodeCommunication = value
    }

    /**
     * @param value The Batch service does not assign any meaning to metadata; it is solely for the use of user code.
     */
    @JvmName("bnrpddoghrbfuayd")
    public suspend fun metadata(`value`: Output<List<MetadataItemArgs>>) {
        this.metadata = value
    }

    @JvmName("wugpayxfljkslldg")
    public suspend fun metadata(vararg values: Output<MetadataItemArgs>) {
        this.metadata = Output.all(values.asList())
    }

    /**
     * @param values The Batch service does not assign any meaning to metadata; it is solely for the use of user code.
     */
    @JvmName("xptkgjcfyrlfnbao")
    public suspend fun metadata(values: List<Output<MetadataItemArgs>>) {
        this.metadata = Output.all(values)
    }

    /**
     * @param value This supports Azure Files, NFS, CIFS/SMB, and Blobfuse.
     */
    @JvmName("blflcyljwenbkxxv")
    public suspend fun mountConfiguration(`value`: Output<List<MountConfigurationArgs>>) {
        this.mountConfiguration = value
    }

    @JvmName("sqbjactlygbahnxd")
    public suspend fun mountConfiguration(vararg values: Output<MountConfigurationArgs>) {
        this.mountConfiguration = Output.all(values.asList())
    }

    /**
     * @param values This supports Azure Files, NFS, CIFS/SMB, and Blobfuse.
     */
    @JvmName("xtryjwftxqoelqlo")
    public suspend fun mountConfiguration(values: List<Output<MountConfigurationArgs>>) {
        this.mountConfiguration = Output.all(values)
    }

    /**
     * @param value The network configuration for a pool.
     */
    @JvmName("aqacuymjpvoippcj")
    public suspend fun networkConfiguration(`value`: Output<NetworkConfigurationArgs>) {
        this.networkConfiguration = value
    }

    /**
     * @param value The pool name. This must be unique within the account.
     */
    @JvmName("wgpgvqnvwysysnpx")
    public suspend fun poolName(`value`: Output<String>) {
        this.poolName = value
    }

    /**
     * @param value The name of the resource group that contains the Batch account.
     */
    @JvmName("ufvwdmlcddmifsuc")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Defines the desired size of the pool. This can either be 'fixedScale' where the requested targetDedicatedNodes is specified, or 'autoScale' which defines a formula which is periodically reevaluated. If this property is not specified, the pool will have a fixed scale with 0 targetDedicatedNodes.
     */
    @JvmName("mobvutugwdcpxpbt")
    public suspend fun scaleSettings(`value`: Output<ScaleSettingsArgs>) {
        this.scaleSettings = value
    }

    /**
     * @param value In an PATCH (update) operation, this property can be set to an empty object to remove the start task from the pool.
     */
    @JvmName("ymqbauustgvrqajg")
    public suspend fun startTask(`value`: Output<StartTaskArgs>) {
        this.startTask = value
    }

    /**
     * @param value If omitted, the default value is Default.
     */
    @JvmName("tsemecoxwjyivsaa")
    public suspend fun targetNodeCommunicationMode(`value`: Output<NodeCommunicationMode>) {
        this.targetNodeCommunicationMode = value
    }

    /**
     * @param value If not specified, the default is spread.
     */
    @JvmName("vggsnrdfksqjdiip")
    public suspend fun taskSchedulingPolicy(`value`: Output<TaskSchedulingPolicyArgs>) {
        this.taskSchedulingPolicy = value
    }

    /**
     * @param value The default value is 1. The maximum value is the smaller of 4 times the number of cores of the vmSize of the pool or 256.
     */
    @JvmName("bfewskucmhbebsds")
    public suspend fun taskSlotsPerNode(`value`: Output<Int>) {
        this.taskSlotsPerNode = value
    }

    /**
     * @param value
     */
    @JvmName("dxbahvpieuvhvgpc")
    public suspend fun userAccounts(`value`: Output<List<UserAccountArgs>>) {
        this.userAccounts = value
    }

    @JvmName("uccyrqspuwcaqlao")
    public suspend fun userAccounts(vararg values: Output<UserAccountArgs>) {
        this.userAccounts = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("vaklkbyrxoxqsamj")
    public suspend fun userAccounts(values: List<Output<UserAccountArgs>>) {
        this.userAccounts = Output.all(values)
    }

    /**
     * @param value For information about available sizes of virtual machines for Cloud Services pools (pools created with cloudServiceConfiguration), see Sizes for Cloud Services (https://azure.microsoft.com/documentation/articles/cloud-services-sizes-specs/). Batch supports all Cloud Services VM sizes except ExtraSmall. For information about available VM sizes for pools using images from the Virtual Machines Marketplace (pools created with virtualMachineConfiguration) see Sizes for Virtual Machines (Linux) (https://azure.microsoft.com/documentation/articles/virtual-machines-linux-sizes/) or Sizes for Virtual Machines (Windows) (https://azure.microsoft.com/documentation/articles/virtual-machines-windows-sizes/). Batch supports all Azure VM sizes except STANDARD_A0 and those with premium storage (STANDARD_GS, STANDARD_DS, and STANDARD_DSV2 series).
     */
    @JvmName("wkkugcmbpisqmqeg")
    public suspend fun vmSize(`value`: Output<String>) {
        this.vmSize = value
    }

    /**
     * @param value The name of the Batch account.
     */
    @JvmName("coxuegpqseceitsh")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The list of application licenses must be a subset of available Batch service application licenses. If a license is requested which is not supported, pool creation will fail.
     */
    @JvmName("tioqcmnpusyuhlcc")
    public suspend fun applicationLicenses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationLicenses = mapped
    }

    /**
     * @param values The list of application licenses must be a subset of available Batch service application licenses. If a license is requested which is not supported, pool creation will fail.
     */
    @JvmName("qikyxxnnxdbotstg")
    public suspend fun applicationLicenses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applicationLicenses = mapped
    }

    /**
     * @param value Changes to application package references affect all new compute nodes joining the pool, but do not affect compute nodes that are already in the pool until they are rebooted or reimaged. There is a maximum of 10 application package references on any given pool.
     */
    @JvmName("tupkejocfndjrppi")
    public suspend fun applicationPackages(`value`: List<ApplicationPackageReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationPackages = mapped
    }

    /**
     * @param argument Changes to application package references affect all new compute nodes joining the pool, but do not affect compute nodes that are already in the pool until they are rebooted or reimaged. There is a maximum of 10 application package references on any given pool.
     */
    @JvmName("ieqdldvunlbsyhut")
    public suspend
    fun applicationPackages(argument: List<suspend ApplicationPackageReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationPackageReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.applicationPackages = mapped
    }

    /**
     * @param argument Changes to application package references affect all new compute nodes joining the pool, but do not affect compute nodes that are already in the pool until they are rebooted or reimaged. There is a maximum of 10 application package references on any given pool.
     */
    @JvmName("tkuuitaergwowloe")
    public suspend fun applicationPackages(
        vararg
        argument: suspend ApplicationPackageReferenceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationPackageReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.applicationPackages = mapped
    }

    /**
     * @param argument Changes to application package references affect all new compute nodes joining the pool, but do not affect compute nodes that are already in the pool until they are rebooted or reimaged. There is a maximum of 10 application package references on any given pool.
     */
    @JvmName("jwuiniihsadcffix")
    public suspend
    fun applicationPackages(argument: suspend ApplicationPackageReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationPackageReferenceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.applicationPackages = mapped
    }

    /**
     * @param values Changes to application package references affect all new compute nodes joining the pool, but do not affect compute nodes that are already in the pool until they are rebooted or reimaged. There is a maximum of 10 application package references on any given pool.
     */
    @JvmName("dqtmsywlmiysaubj")
    public suspend fun applicationPackages(vararg values: ApplicationPackageReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applicationPackages = mapped
    }

    /**
     * @param value For Windows compute nodes, the Batch service installs the certificates to the specified certificate store and location. For Linux compute nodes, the certificates are stored in a directory inside the task working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this location. For certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's home directory (e.g., /home/{user-name}/certs) and certificates are placed in that directory.
     * Warning: This property is deprecated and will be removed after February, 2024. Please use the [Azure KeyVault Extension](https://learn.microsoft.com/azure/batch/batch-certificate-migration-guide) instead.
     */
    @JvmName("edsnacrjgimcyijv")
    public suspend fun certificates(`value`: List<CertificateReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificates = mapped
    }

    /**
     * @param argument For Windows compute nodes, the Batch service installs the certificates to the specified certificate store and location. For Linux compute nodes, the certificates are stored in a directory inside the task working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this location. For certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's home directory (e.g., /home/{user-name}/certs) and certificates are placed in that directory.
     * Warning: This property is deprecated and will be removed after February, 2024. Please use the [Azure KeyVault Extension](https://learn.microsoft.com/azure/batch/batch-certificate-migration-guide) instead.
     */
    @JvmName("sldhaycjvtmotwxk")
    public suspend
    fun certificates(argument: List<suspend CertificateReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CertificateReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.certificates = mapped
    }

    /**
     * @param argument For Windows compute nodes, the Batch service installs the certificates to the specified certificate store and location. For Linux compute nodes, the certificates are stored in a directory inside the task working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this location. For certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's home directory (e.g., /home/{user-name}/certs) and certificates are placed in that directory.
     * Warning: This property is deprecated and will be removed after February, 2024. Please use the [Azure KeyVault Extension](https://learn.microsoft.com/azure/batch/batch-certificate-migration-guide) instead.
     */
    @JvmName("jmjsnxcvyvtwiehp")
    public suspend fun certificates(
        vararg
        argument: suspend CertificateReferenceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            CertificateReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.certificates = mapped
    }

    /**
     * @param argument For Windows compute nodes, the Batch service installs the certificates to the specified certificate store and location. For Linux compute nodes, the certificates are stored in a directory inside the task working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this location. For certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's home directory (e.g., /home/{user-name}/certs) and certificates are placed in that directory.
     * Warning: This property is deprecated and will be removed after February, 2024. Please use the [Azure KeyVault Extension](https://learn.microsoft.com/azure/batch/batch-certificate-migration-guide) instead.
     */
    @JvmName("trhkfhioxniosgar")
    public suspend fun certificates(argument: suspend CertificateReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(CertificateReferenceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.certificates = mapped
    }

    /**
     * @param values For Windows compute nodes, the Batch service installs the certificates to the specified certificate store and location. For Linux compute nodes, the certificates are stored in a directory inside the task working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this location. For certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's home directory (e.g., /home/{user-name}/certs) and certificates are placed in that directory.
     * Warning: This property is deprecated and will be removed after February, 2024. Please use the [Azure KeyVault Extension](https://learn.microsoft.com/azure/batch/batch-certificate-migration-guide) instead.
     */
    @JvmName("edwvcoraufkhpkux")
    public suspend fun certificates(vararg values: CertificateReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificates = mapped
    }

    /**
     * @param value Using CloudServiceConfiguration specifies that the nodes should be creating using Azure Cloud Services (PaaS), while VirtualMachineConfiguration uses Azure Virtual Machines (IaaS).
     */
    @JvmName("ocxsbqkysnrkxqsd")
    public suspend fun deploymentConfiguration(`value`: DeploymentConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentConfiguration = mapped
    }

    /**
     * @param argument Using CloudServiceConfiguration specifies that the nodes should be creating using Azure Cloud Services (PaaS), while VirtualMachineConfiguration uses Azure Virtual Machines (IaaS).
     */
    @JvmName("njgcevlpariiwvea")
    public suspend
    fun deploymentConfiguration(argument: suspend DeploymentConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = DeploymentConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.deploymentConfiguration = mapped
    }

    /**
     * @param value The display name need not be unique and can contain any Unicode characters up to a maximum length of 1024.
     */
    @JvmName("djrewtfykdonklco")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The type of identity used for the Batch Pool.
     */
    @JvmName("bgbpnhsjxyaeckec")
    public suspend fun identity(`value`: BatchPoolIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The type of identity used for the Batch Pool.
     */
    @JvmName("mmpyifovuimfxkmw")
    public suspend fun identity(argument: suspend BatchPoolIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = BatchPoolIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value This imposes restrictions on which nodes can be assigned to the pool. Enabling this value can reduce the chance of the requested number of nodes to be allocated in the pool. If not specified, this value defaults to 'Disabled'.
     */
    @JvmName("lmjrbliumdennuut")
    public suspend fun interNodeCommunication(`value`: InterNodeCommunicationState?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interNodeCommunication = mapped
    }

    /**
     * @param value The Batch service does not assign any meaning to metadata; it is solely for the use of user code.
     */
    @JvmName("qwniknvyquaprlhb")
    public suspend fun metadata(`value`: List<MetadataItemArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param argument The Batch service does not assign any meaning to metadata; it is solely for the use of user code.
     */
    @JvmName("bhhvuegonjdxoadr")
    public suspend fun metadata(argument: List<suspend MetadataItemArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MetadataItemArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.metadata = mapped
    }

    /**
     * @param argument The Batch service does not assign any meaning to metadata; it is solely for the use of user code.
     */
    @JvmName("jdpwwvsivhvsvddv")
    public suspend fun metadata(vararg argument: suspend MetadataItemArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            MetadataItemArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.metadata = mapped
    }

    /**
     * @param argument The Batch service does not assign any meaning to metadata; it is solely for the use of user code.
     */
    @JvmName("vprvaicijmaxehdv")
    public suspend fun metadata(argument: suspend MetadataItemArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(MetadataItemArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.metadata = mapped
    }

    /**
     * @param values The Batch service does not assign any meaning to metadata; it is solely for the use of user code.
     */
    @JvmName("pyprxvdfqtmcddrq")
    public suspend fun metadata(vararg values: MetadataItemArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value This supports Azure Files, NFS, CIFS/SMB, and Blobfuse.
     */
    @JvmName("fmblddgfoyvbwpyt")
    public suspend fun mountConfiguration(`value`: List<MountConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mountConfiguration = mapped
    }

    /**
     * @param argument This supports Azure Files, NFS, CIFS/SMB, and Blobfuse.
     */
    @JvmName("gkatpaecdfuxxibd")
    public suspend
    fun mountConfiguration(argument: List<suspend MountConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MountConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.mountConfiguration = mapped
    }

    /**
     * @param argument This supports Azure Files, NFS, CIFS/SMB, and Blobfuse.
     */
    @JvmName("dslewvgtooyjcrwx")
    public suspend fun mountConfiguration(
        vararg
        argument: suspend MountConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MountConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.mountConfiguration = mapped
    }

    /**
     * @param argument This supports Azure Files, NFS, CIFS/SMB, and Blobfuse.
     */
    @JvmName("owmkaghvkqjoiggr")
    public suspend
    fun mountConfiguration(argument: suspend MountConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(MountConfigurationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.mountConfiguration = mapped
    }

    /**
     * @param values This supports Azure Files, NFS, CIFS/SMB, and Blobfuse.
     */
    @JvmName("ihdkdoeuoxqbwfxu")
    public suspend fun mountConfiguration(vararg values: MountConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mountConfiguration = mapped
    }

    /**
     * @param value The network configuration for a pool.
     */
    @JvmName("opctvnayileqtsva")
    public suspend fun networkConfiguration(`value`: NetworkConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkConfiguration = mapped
    }

    /**
     * @param argument The network configuration for a pool.
     */
    @JvmName("tskolblodguhpgxj")
    public suspend
    fun networkConfiguration(argument: suspend NetworkConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkConfiguration = mapped
    }

    /**
     * @param value The pool name. This must be unique within the account.
     */
    @JvmName("qlqwvcevntlosaes")
    public suspend fun poolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.poolName = mapped
    }

    /**
     * @param value The name of the resource group that contains the Batch account.
     */
    @JvmName("yrrcjcrrdbgaumpp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Defines the desired size of the pool. This can either be 'fixedScale' where the requested targetDedicatedNodes is specified, or 'autoScale' which defines a formula which is periodically reevaluated. If this property is not specified, the pool will have a fixed scale with 0 targetDedicatedNodes.
     */
    @JvmName("fedeqcslqlgkpxkw")
    public suspend fun scaleSettings(`value`: ScaleSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scaleSettings = mapped
    }

    /**
     * @param argument Defines the desired size of the pool. This can either be 'fixedScale' where the requested targetDedicatedNodes is specified, or 'autoScale' which defines a formula which is periodically reevaluated. If this property is not specified, the pool will have a fixed scale with 0 targetDedicatedNodes.
     */
    @JvmName("qcpakvcsenwahcti")
    public suspend fun scaleSettings(argument: suspend ScaleSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ScaleSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.scaleSettings = mapped
    }

    /**
     * @param value In an PATCH (update) operation, this property can be set to an empty object to remove the start task from the pool.
     */
    @JvmName("mnpwrmnusstikjhm")
    public suspend fun startTask(`value`: StartTaskArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startTask = mapped
    }

    /**
     * @param argument In an PATCH (update) operation, this property can be set to an empty object to remove the start task from the pool.
     */
    @JvmName("mgslbumvycxgbwsm")
    public suspend fun startTask(argument: suspend StartTaskArgsBuilder.() -> Unit) {
        val toBeMapped = StartTaskArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.startTask = mapped
    }

    /**
     * @param value If omitted, the default value is Default.
     */
    @JvmName("hcdjowdtxpgdoqwa")
    public suspend fun targetNodeCommunicationMode(`value`: NodeCommunicationMode?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetNodeCommunicationMode = mapped
    }

    /**
     * @param value If not specified, the default is spread.
     */
    @JvmName("ewmqgdwhkevecjqc")
    public suspend fun taskSchedulingPolicy(`value`: TaskSchedulingPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.taskSchedulingPolicy = mapped
    }

    /**
     * @param argument If not specified, the default is spread.
     */
    @JvmName("hmbmxefggvoyuwig")
    public suspend
    fun taskSchedulingPolicy(argument: suspend TaskSchedulingPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = TaskSchedulingPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.taskSchedulingPolicy = mapped
    }

    /**
     * @param value The default value is 1. The maximum value is the smaller of 4 times the number of cores of the vmSize of the pool or 256.
     */
    @JvmName("hdekhmfrqjfwpbjl")
    public suspend fun taskSlotsPerNode(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.taskSlotsPerNode = mapped
    }

    /**
     * @param value
     */
    @JvmName("rqxqgxuxxjbpaykx")
    public suspend fun userAccounts(`value`: List<UserAccountArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAccounts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("hxywieoctisbkfgx")
    public suspend fun userAccounts(argument: List<suspend UserAccountArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { UserAccountArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.userAccounts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("mkjugwqtykijtycg")
    public suspend fun userAccounts(vararg argument: suspend UserAccountArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { UserAccountArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.userAccounts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("lkqbrstpgegfxapm")
    public suspend fun userAccounts(argument: suspend UserAccountArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(UserAccountArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.userAccounts = mapped
    }

    /**
     * @param values
     */
    @JvmName("hryyjnagluvdfiyg")
    public suspend fun userAccounts(vararg values: UserAccountArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userAccounts = mapped
    }

    /**
     * @param value For information about available sizes of virtual machines for Cloud Services pools (pools created with cloudServiceConfiguration), see Sizes for Cloud Services (https://azure.microsoft.com/documentation/articles/cloud-services-sizes-specs/). Batch supports all Cloud Services VM sizes except ExtraSmall. For information about available VM sizes for pools using images from the Virtual Machines Marketplace (pools created with virtualMachineConfiguration) see Sizes for Virtual Machines (Linux) (https://azure.microsoft.com/documentation/articles/virtual-machines-linux-sizes/) or Sizes for Virtual Machines (Windows) (https://azure.microsoft.com/documentation/articles/virtual-machines-windows-sizes/). Batch supports all Azure VM sizes except STANDARD_A0 and those with premium storage (STANDARD_GS, STANDARD_DS, and STANDARD_DSV2 series).
     */
    @JvmName("bawlcgthpagykqws")
    public suspend fun vmSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmSize = mapped
    }

    internal fun build(): PoolArgs = PoolArgs(
        accountName = accountName,
        applicationLicenses = applicationLicenses,
        applicationPackages = applicationPackages,
        certificates = certificates,
        deploymentConfiguration = deploymentConfiguration,
        displayName = displayName,
        identity = identity,
        interNodeCommunication = interNodeCommunication,
        metadata = metadata,
        mountConfiguration = mountConfiguration,
        networkConfiguration = networkConfiguration,
        poolName = poolName,
        resourceGroupName = resourceGroupName,
        scaleSettings = scaleSettings,
        startTask = startTask,
        targetNodeCommunicationMode = targetNodeCommunicationMode,
        taskSchedulingPolicy = taskSchedulingPolicy,
        taskSlotsPerNode = taskSlotsPerNode,
        userAccounts = userAccounts,
        vmSize = vmSize,
    )
}
