@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The authentication mode which the Batch service will use to manage the auto-storage account.
 */
public enum class AutoStorageAuthenticationMode(
    public val javaValue: com.pulumi.azurenative.batch.enums.AutoStorageAuthenticationMode,
) : ConvertibleToJava<com.pulumi.azurenative.batch.enums.AutoStorageAuthenticationMode> {
    /**
     * The Batch service will authenticate requests to auto-storage using storage account keys.
     */
    StorageKeys(com.pulumi.azurenative.batch.enums.AutoStorageAuthenticationMode.StorageKeys),

    /**
     * The Batch service will authenticate requests to auto-storage using the managed identity assigned to the Batch account.
     */
    BatchAccountManagedIdentity(com.pulumi.azurenative.batch.enums.AutoStorageAuthenticationMode.BatchAccountManagedIdentity),
    ;

    override fun toJava(): com.pulumi.azurenative.batch.enums.AutoStorageAuthenticationMode =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.enums.AutoStorageAuthenticationMode):
            AutoStorageAuthenticationMode =
            AutoStorageAuthenticationMode.values().first { it.javaValue == javaType }
    }
}
