@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Values are:
 *  none - The caching mode for the disk is not enabled.
 *  readOnly - The caching mode for the disk is read only.
 *  readWrite - The caching mode for the disk is read and write.
 *  The default value for caching is none. For information about the caching options see: https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/.
 */
public enum class CachingType(
    public val javaValue: com.pulumi.azurenative.batch.enums.CachingType,
) : ConvertibleToJava<com.pulumi.azurenative.batch.enums.CachingType> {
    /**
     * The caching mode for the disk is not enabled.
     */
    None(com.pulumi.azurenative.batch.enums.CachingType.None),

    /**
     * The caching mode for the disk is read only.
     */
    ReadOnly(com.pulumi.azurenative.batch.enums.CachingType.ReadOnly),

    /**
     * The caching mode for the disk is read and write.
     */
    ReadWrite(com.pulumi.azurenative.batch.enums.CachingType.ReadWrite),
    ;

    override fun toJava(): com.pulumi.azurenative.batch.enums.CachingType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.enums.CachingType): CachingType =
            CachingType.values().first { it.javaValue == javaType }
    }
}
