@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * If omitted, the default value is Requeue.
 */
public enum class ComputeNodeDeallocationOption(
    public val javaValue: com.pulumi.azurenative.batch.enums.ComputeNodeDeallocationOption,
) : ConvertibleToJava<com.pulumi.azurenative.batch.enums.ComputeNodeDeallocationOption> {
    /**
     * Terminate running task processes and requeue the tasks. The tasks will run again when a node is available. Remove nodes as soon as tasks have been terminated.
     */
    Requeue(com.pulumi.azurenative.batch.enums.ComputeNodeDeallocationOption.Requeue),

    /**
     * Terminate running tasks. The tasks will be completed with failureInfo indicating that they were terminated, and will not run again. Remove nodes as soon as tasks have been terminated.
     */
    Terminate(com.pulumi.azurenative.batch.enums.ComputeNodeDeallocationOption.Terminate),

    /**
     * Allow currently running tasks to complete. Schedule no new tasks while waiting. Remove nodes when all tasks have completed.
     */
    TaskCompletion(com.pulumi.azurenative.batch.enums.ComputeNodeDeallocationOption.TaskCompletion),

    /**
     * Allow currently running tasks to complete, then wait for all task data retention periods to expire. Schedule no new tasks while waiting. Remove nodes when all task retention periods have expired.
     */
    RetainedData(com.pulumi.azurenative.batch.enums.ComputeNodeDeallocationOption.RetainedData),
    ;

    override fun toJava(): com.pulumi.azurenative.batch.enums.ComputeNodeDeallocationOption =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.enums.ComputeNodeDeallocationOption):
            ComputeNodeDeallocationOption =
            ComputeNodeDeallocationOption.values().first { it.javaValue == javaType }
    }
}
