@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

public enum class ContainerType(
    public val javaValue: com.pulumi.azurenative.batch.enums.ContainerType,
) : ConvertibleToJava<com.pulumi.azurenative.batch.enums.ContainerType> {
    /**
     * A Docker compatible container technology will be used to launch the containers.
     */
    DockerCompatible(com.pulumi.azurenative.batch.enums.ContainerType.DockerCompatible),

    /**
     * A CRI based technology will be used to launch the containers.
     */
    CriCompatible(com.pulumi.azurenative.batch.enums.ContainerType.CriCompatible),
    ;

    override fun toJava(): com.pulumi.azurenative.batch.enums.ContainerType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.enums.ContainerType): ContainerType =
            ContainerType.values().first { it.javaValue == javaType }
    }
}
