@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * nonAdmin - The auto user is a standard user without elevated access. admin - The auto user is a user with elevated access and operates with full Administrator permissions. The default value is nonAdmin.
 */
public enum class ElevationLevel(
    public val javaValue: com.pulumi.azurenative.batch.enums.ElevationLevel,
) : ConvertibleToJava<com.pulumi.azurenative.batch.enums.ElevationLevel> {
    /**
     * The user is a standard user without elevated access.
     */
    NonAdmin(com.pulumi.azurenative.batch.enums.ElevationLevel.NonAdmin),

    /**
     * The user is a user with elevated access and operates with full Administrator permissions.
     */
    Admin(com.pulumi.azurenative.batch.enums.ElevationLevel.Admin),
    ;

    override fun toJava(): com.pulumi.azurenative.batch.enums.ElevationLevel = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.enums.ElevationLevel): ElevationLevel =
            ElevationLevel.values().first { it.javaValue == javaType }
    }
}
