@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The default value is BatchManaged
 */
public enum class IPAddressProvisioningType(
    public val javaValue: com.pulumi.azurenative.batch.enums.IPAddressProvisioningType,
) : ConvertibleToJava<com.pulumi.azurenative.batch.enums.IPAddressProvisioningType> {
    /**
     * A public IP will be created and managed by Batch. There may be multiple public IPs depending on the size of the Pool.
     */
    BatchManaged(com.pulumi.azurenative.batch.enums.IPAddressProvisioningType.BatchManaged),

    /**
     * Public IPs are provided by the user and will be used to provision the Compute Nodes.
     */
    UserManaged(com.pulumi.azurenative.batch.enums.IPAddressProvisioningType.UserManaged),

    /**
     * No public IP Address will be created for the Compute Nodes in the Pool.
     */
    NoPublicIPAddresses(com.pulumi.azurenative.batch.enums.IPAddressProvisioningType.NoPublicIPAddresses),
    ;

    override fun toJava(): com.pulumi.azurenative.batch.enums.IPAddressProvisioningType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.enums.IPAddressProvisioningType):
            IPAddressProvisioningType =
            IPAddressProvisioningType.values().first { it.javaValue == javaType }
    }
}
