@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Action when client IP address is matched.
 */
public enum class IPRuleAction(
    public val javaValue: com.pulumi.azurenative.batch.enums.IPRuleAction,
) : ConvertibleToJava<com.pulumi.azurenative.batch.enums.IPRuleAction> {
    /**
     * Allow access for the matched client IP address.
     */
    Allow(com.pulumi.azurenative.batch.enums.IPRuleAction.Allow),
    ;

    override fun toJava(): com.pulumi.azurenative.batch.enums.IPRuleAction = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.enums.IPRuleAction): IPRuleAction =
            IPRuleAction.values().first { it.javaValue == javaType }
    }
}
