@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * If omitted, the default value is Default.
 */
public enum class NodeCommunicationMode(
    public val javaValue: com.pulumi.azurenative.batch.enums.NodeCommunicationMode,
) : ConvertibleToJava<com.pulumi.azurenative.batch.enums.NodeCommunicationMode> {
    /**
     * The node communication mode is automatically set by the Batch service.
     */
    Default(com.pulumi.azurenative.batch.enums.NodeCommunicationMode.Default),

    /**
     * Nodes using the Classic communication mode require inbound TCP communication on ports 29876 and 29877 from the "BatchNodeManagement.{region}" service tag and outbound TCP communication on port 443 to the "Storage.region" and "BatchNodeManagement.{region}" service tags.
     */
    Classic(com.pulumi.azurenative.batch.enums.NodeCommunicationMode.Classic),

    /**
     * Nodes using the Simplified communication mode require outbound TCP communication on port 443 to the "BatchNodeManagement.{region}" service tag. No open inbound ports are required.
     */
    Simplified(com.pulumi.azurenative.batch.enums.NodeCommunicationMode.Simplified),
    ;

    override fun toJava(): com.pulumi.azurenative.batch.enums.NodeCommunicationMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.enums.NodeCommunicationMode):
            NodeCommunicationMode = NodeCommunicationMode.values().first { it.javaValue == javaType }
    }
}
