@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * If not specified, the default value is 'enabled'.
 */
public enum class PublicNetworkAccessType(
    public val javaValue: com.pulumi.azurenative.batch.enums.PublicNetworkAccessType,
) : ConvertibleToJava<com.pulumi.azurenative.batch.enums.PublicNetworkAccessType> {
    /**
     * Enables connectivity to Azure Batch through public DNS.
     */
    Enabled(com.pulumi.azurenative.batch.enums.PublicNetworkAccessType.Enabled),

    /**
     * Disables public connectivity and enables private connectivity to Azure Batch Service through private endpoint resource.
     */
    Disabled(com.pulumi.azurenative.batch.enums.PublicNetworkAccessType.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.batch.enums.PublicNetworkAccessType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.enums.PublicNetworkAccessType):
            PublicNetworkAccessType =
            PublicNetworkAccessType.values().first { it.javaValue == javaType }
    }
}
