@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * If omitted, the default is "Standard_LRS". Values are:
 *  Standard_LRS - The data disk should use standard locally redundant storage.
 *  Premium_LRS - The data disk should use premium locally redundant storage.
 */
public enum class StorageAccountType(
    public val javaValue: com.pulumi.azurenative.batch.enums.StorageAccountType,
) : ConvertibleToJava<com.pulumi.azurenative.batch.enums.StorageAccountType> {
    /**
     * The data disk should use standard locally redundant storage.
     */
    Standard_LRS(com.pulumi.azurenative.batch.enums.StorageAccountType.Standard_LRS),

    /**
     * The data disk should use premium locally redundant storage.
     */
    Premium_LRS(com.pulumi.azurenative.batch.enums.StorageAccountType.Premium_LRS),
    ;

    override fun toJava(): com.pulumi.azurenative.batch.enums.StorageAccountType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.enums.StorageAccountType):
            StorageAccountType = StorageAccountType.values().first { it.javaValue == javaType }
    }
}
