@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.AutoStorageBasePropertiesArgs.builder
import com.pulumi.azurenative.batch.kotlin.enums.AutoStorageAuthenticationMode
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The properties related to the auto-storage account.
 * @property authenticationMode The authentication mode which the Batch service will use to manage the auto-storage account.
 * @property nodeIdentityReference The identity referenced here must be assigned to pools which have compute nodes that need access to auto-storage.
 * @property storageAccountId The resource ID of the storage account to be used for auto-storage account.
 */
public data class AutoStorageBasePropertiesArgs(
    public val authenticationMode: Output<AutoStorageAuthenticationMode>? = null,
    public val nodeIdentityReference: Output<ComputeNodeIdentityReferenceArgs>? = null,
    public val storageAccountId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.AutoStorageBasePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.AutoStorageBasePropertiesArgs =
        com.pulumi.azurenative.batch.inputs.AutoStorageBasePropertiesArgs.builder()
            .authenticationMode(
                authenticationMode?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .nodeIdentityReference(
                nodeIdentityReference?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .storageAccountId(storageAccountId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AutoStorageBasePropertiesArgs].
 */
@PulumiTagMarker
public class AutoStorageBasePropertiesArgsBuilder internal constructor() {
    private var authenticationMode: Output<AutoStorageAuthenticationMode>? = null

    private var nodeIdentityReference: Output<ComputeNodeIdentityReferenceArgs>? = null

    private var storageAccountId: Output<String>? = null

    /**
     * @param value The authentication mode which the Batch service will use to manage the auto-storage account.
     */
    @JvmName("fkpmduyutprhdxsr")
    public suspend fun authenticationMode(`value`: Output<AutoStorageAuthenticationMode>) {
        this.authenticationMode = value
    }

    /**
     * @param value The identity referenced here must be assigned to pools which have compute nodes that need access to auto-storage.
     */
    @JvmName("cpgrqjhhvdadwxat")
    public suspend fun nodeIdentityReference(`value`: Output<ComputeNodeIdentityReferenceArgs>) {
        this.nodeIdentityReference = value
    }

    /**
     * @param value The resource ID of the storage account to be used for auto-storage account.
     */
    @JvmName("sfkawcnwnuubkyee")
    public suspend fun storageAccountId(`value`: Output<String>) {
        this.storageAccountId = value
    }

    /**
     * @param value The authentication mode which the Batch service will use to manage the auto-storage account.
     */
    @JvmName("gxjojvbfbkdyksta")
    public suspend fun authenticationMode(`value`: AutoStorageAuthenticationMode?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationMode = mapped
    }

    /**
     * @param value The identity referenced here must be assigned to pools which have compute nodes that need access to auto-storage.
     */
    @JvmName("kjvggknrywjhpcsn")
    public suspend fun nodeIdentityReference(`value`: ComputeNodeIdentityReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeIdentityReference = mapped
    }

    /**
     * @param argument The identity referenced here must be assigned to pools which have compute nodes that need access to auto-storage.
     */
    @JvmName("rrptayuantidnlbb")
    public suspend
    fun nodeIdentityReference(argument: suspend ComputeNodeIdentityReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ComputeNodeIdentityReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.nodeIdentityReference = mapped
    }

    /**
     * @param value The resource ID of the storage account to be used for auto-storage account.
     */
    @JvmName("woliodcpbecksqib")
    public suspend fun storageAccountId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageAccountId = mapped
    }

    internal fun build(): AutoStorageBasePropertiesArgs = AutoStorageBasePropertiesArgs(
        authenticationMode = authenticationMode,
        nodeIdentityReference = nodeIdentityReference,
        storageAccountId = storageAccountId ?: throw PulumiNullFieldException("storageAccountId"),
    )
}
