@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.BatchPoolIdentityArgs.builder
import com.pulumi.azurenative.batch.kotlin.enums.PoolIdentityType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The identity of the Batch pool, if configured. If the pool identity is updated during update an existing pool, only the new vms which are created after the pool shrinks to 0 will have the updated identities
 * @property type The type of identity used for the Batch Pool.
 * @property userAssignedIdentities The list of user identities associated with the Batch pool.
 */
public data class BatchPoolIdentityArgs(
    public val type: Output<PoolIdentityType>,
    public val userAssignedIdentities: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.BatchPoolIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.BatchPoolIdentityArgs =
        com.pulumi.azurenative.batch.inputs.BatchPoolIdentityArgs.builder()
            .type(type.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .userAssignedIdentities(
                userAssignedIdentities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [BatchPoolIdentityArgs].
 */
@PulumiTagMarker
public class BatchPoolIdentityArgsBuilder internal constructor() {
    private var type: Output<PoolIdentityType>? = null

    private var userAssignedIdentities: Output<List<String>>? = null

    /**
     * @param value The type of identity used for the Batch Pool.
     */
    @JvmName("idajeqycrdmlouck")
    public suspend fun type(`value`: Output<PoolIdentityType>) {
        this.type = value
    }

    /**
     * @param value The list of user identities associated with the Batch pool.
     */
    @JvmName("nhfnqjfibnocmvfv")
    public suspend fun userAssignedIdentities(`value`: Output<List<String>>) {
        this.userAssignedIdentities = value
    }

    @JvmName("scvsieidrqihyjbq")
    public suspend fun userAssignedIdentities(vararg values: Output<String>) {
        this.userAssignedIdentities = Output.all(values.asList())
    }

    /**
     * @param values The list of user identities associated with the Batch pool.
     */
    @JvmName("ghrwfwsgqkpsfneg")
    public suspend fun userAssignedIdentities(values: List<Output<String>>) {
        this.userAssignedIdentities = Output.all(values)
    }

    /**
     * @param value The type of identity used for the Batch Pool.
     */
    @JvmName("uvorbsfdcootlxgb")
    public suspend fun type(`value`: PoolIdentityType) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The list of user identities associated with the Batch pool.
     */
    @JvmName("jpicqsqhyysqwsqn")
    public suspend fun userAssignedIdentities(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    /**
     * @param values The list of user identities associated with the Batch pool.
     */
    @JvmName("eccydslwwdgfbntg")
    public suspend fun userAssignedIdentities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    internal fun build(): BatchPoolIdentityArgs = BatchPoolIdentityArgs(
        type = type ?: throw PulumiNullFieldException("type"),
        userAssignedIdentities = userAssignedIdentities,
    )
}
