@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.ComputeNodeIdentityReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The reference to a user assigned identity associated with the Batch pool which a compute node will use.
 * @property resourceId The ARM resource id of the user assigned identity.
 */
public data class ComputeNodeIdentityReferenceArgs(
    public val resourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.ComputeNodeIdentityReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.ComputeNodeIdentityReferenceArgs =
        com.pulumi.azurenative.batch.inputs.ComputeNodeIdentityReferenceArgs.builder()
            .resourceId(resourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ComputeNodeIdentityReferenceArgs].
 */
@PulumiTagMarker
public class ComputeNodeIdentityReferenceArgsBuilder internal constructor() {
    private var resourceId: Output<String>? = null

    /**
     * @param value The ARM resource id of the user assigned identity.
     */
    @JvmName("okgdbsklybhqnooa")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value The ARM resource id of the user assigned identity.
     */
    @JvmName("awdxvbfqieihsfra")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    internal fun build(): ComputeNodeIdentityReferenceArgs = ComputeNodeIdentityReferenceArgs(
        resourceId = resourceId,
    )
}
