@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.ContainerConfigurationArgs.builder
import com.pulumi.azurenative.batch.kotlin.enums.ContainerType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property containerImageNames This is the full image reference, as would be specified to "docker pull". An image will be sourced from the default Docker registry unless the image is fully qualified with an alternative registry.
 * @property containerRegistries If any images must be downloaded from a private registry which requires credentials, then those credentials must be provided here.
 * @property type
 */
public data class ContainerConfigurationArgs(
    public val containerImageNames: Output<List<String>>? = null,
    public val containerRegistries: Output<List<ContainerRegistryArgs>>? = null,
    public val type: Output<Either<String, ContainerType>>,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.ContainerConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.ContainerConfigurationArgs =
        com.pulumi.azurenative.batch.inputs.ContainerConfigurationArgs.builder()
            .containerImageNames(containerImageNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .containerRegistries(
                containerRegistries?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ContainerConfigurationArgs].
 */
@PulumiTagMarker
public class ContainerConfigurationArgsBuilder internal constructor() {
    private var containerImageNames: Output<List<String>>? = null

    private var containerRegistries: Output<List<ContainerRegistryArgs>>? = null

    private var type: Output<Either<String, ContainerType>>? = null

    /**
     * @param value This is the full image reference, as would be specified to "docker pull". An image will be sourced from the default Docker registry unless the image is fully qualified with an alternative registry.
     */
    @JvmName("fiuplhxevfktscpj")
    public suspend fun containerImageNames(`value`: Output<List<String>>) {
        this.containerImageNames = value
    }

    @JvmName("xvxlrsmcajunpclr")
    public suspend fun containerImageNames(vararg values: Output<String>) {
        this.containerImageNames = Output.all(values.asList())
    }

    /**
     * @param values This is the full image reference, as would be specified to "docker pull". An image will be sourced from the default Docker registry unless the image is fully qualified with an alternative registry.
     */
    @JvmName("mqrtkcckvltnvjaj")
    public suspend fun containerImageNames(values: List<Output<String>>) {
        this.containerImageNames = Output.all(values)
    }

    /**
     * @param value If any images must be downloaded from a private registry which requires credentials, then those credentials must be provided here.
     */
    @JvmName("wjxmkvlrppfxlxuo")
    public suspend fun containerRegistries(`value`: Output<List<ContainerRegistryArgs>>) {
        this.containerRegistries = value
    }

    @JvmName("rjuooxkudgcxpiib")
    public suspend fun containerRegistries(vararg values: Output<ContainerRegistryArgs>) {
        this.containerRegistries = Output.all(values.asList())
    }

    /**
     * @param values If any images must be downloaded from a private registry which requires credentials, then those credentials must be provided here.
     */
    @JvmName("twxujlxovfmgydgo")
    public suspend fun containerRegistries(values: List<Output<ContainerRegistryArgs>>) {
        this.containerRegistries = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("ytopbfgjmnojxime")
    public suspend fun type(`value`: Output<Either<String, ContainerType>>) {
        this.type = value
    }

    /**
     * @param value This is the full image reference, as would be specified to "docker pull". An image will be sourced from the default Docker registry unless the image is fully qualified with an alternative registry.
     */
    @JvmName("ljbibonhifkxawjm")
    public suspend fun containerImageNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerImageNames = mapped
    }

    /**
     * @param values This is the full image reference, as would be specified to "docker pull". An image will be sourced from the default Docker registry unless the image is fully qualified with an alternative registry.
     */
    @JvmName("lguxkwfdeadmuawq")
    public suspend fun containerImageNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containerImageNames = mapped
    }

    /**
     * @param value If any images must be downloaded from a private registry which requires credentials, then those credentials must be provided here.
     */
    @JvmName("umeqapukbchbfljk")
    public suspend fun containerRegistries(`value`: List<ContainerRegistryArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerRegistries = mapped
    }

    /**
     * @param argument If any images must be downloaded from a private registry which requires credentials, then those credentials must be provided here.
     */
    @JvmName("vqvmltcxaipbcegx")
    public suspend
    fun containerRegistries(argument: List<suspend ContainerRegistryArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContainerRegistryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.containerRegistries = mapped
    }

    /**
     * @param argument If any images must be downloaded from a private registry which requires credentials, then those credentials must be provided here.
     */
    @JvmName("jaclcusuhljgddhq")
    public suspend fun containerRegistries(
        vararg
        argument: suspend ContainerRegistryArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ContainerRegistryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.containerRegistries = mapped
    }

    /**
     * @param argument If any images must be downloaded from a private registry which requires credentials, then those credentials must be provided here.
     */
    @JvmName("chhdxmctxckajokh")
    public suspend
    fun containerRegistries(argument: suspend ContainerRegistryArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ContainerRegistryArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.containerRegistries = mapped
    }

    /**
     * @param values If any images must be downloaded from a private registry which requires credentials, then those credentials must be provided here.
     */
    @JvmName("shgrpuuhvrpnpliy")
    public suspend fun containerRegistries(vararg values: ContainerRegistryArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containerRegistries = mapped
    }

    /**
     * @param value
     */
    @JvmName("jtrqqfauplbhafxg")
    public suspend fun type(`value`: Either<String, ContainerType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value
     */
    @JvmName("railnmwreyhjvsou")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ContainerType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value
     */
    @JvmName("veocmqrpeeflxffb")
    public fun type(`value`: ContainerType) {
        val toBeMapped = Either.ofRight<String, ContainerType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ContainerConfigurationArgs = ContainerConfigurationArgs(
        containerImageNames = containerImageNames,
        containerRegistries = containerRegistries,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
