@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.DataDiskArgs.builder
import com.pulumi.azurenative.batch.kotlin.enums.CachingType
import com.pulumi.azurenative.batch.kotlin.enums.StorageAccountType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Settings which will be used by the data disks associated to Compute Nodes in the Pool. When using attached data disks, you need to mount and format the disks from within a VM to use them.
 * @property caching Values are:
 *  none - The caching mode for the disk is not enabled.
 *  readOnly - The caching mode for the disk is read only.
 *  readWrite - The caching mode for the disk is read and write.
 *  The default value for caching is none. For information about the caching options see: https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/.
 * @property diskSizeGB
 * @property lun The lun is used to uniquely identify each data disk. If attaching multiple disks, each should have a distinct lun. The value must be between 0 and 63, inclusive.
 * @property storageAccountType If omitted, the default is "Standard_LRS". Values are:
 *  Standard_LRS - The data disk should use standard locally redundant storage.
 *  Premium_LRS - The data disk should use premium locally redundant storage.
 */
public data class DataDiskArgs(
    public val caching: Output<CachingType>? = null,
    public val diskSizeGB: Output<Int>,
    public val lun: Output<Int>,
    public val storageAccountType: Output<StorageAccountType>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.DataDiskArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.DataDiskArgs =
        com.pulumi.azurenative.batch.inputs.DataDiskArgs.builder()
            .caching(caching?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .diskSizeGB(diskSizeGB.applyValue({ args0 -> args0 }))
            .lun(lun.applyValue({ args0 -> args0 }))
            .storageAccountType(
                storageAccountType?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DataDiskArgs].
 */
@PulumiTagMarker
public class DataDiskArgsBuilder internal constructor() {
    private var caching: Output<CachingType>? = null

    private var diskSizeGB: Output<Int>? = null

    private var lun: Output<Int>? = null

    private var storageAccountType: Output<StorageAccountType>? = null

    /**
     * @param value Values are:
     *  none - The caching mode for the disk is not enabled.
     *  readOnly - The caching mode for the disk is read only.
     *  readWrite - The caching mode for the disk is read and write.
     *  The default value for caching is none. For information about the caching options see: https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/.
     */
    @JvmName("uubosonqusaymnkp")
    public suspend fun caching(`value`: Output<CachingType>) {
        this.caching = value
    }

    /**
     * @param value
     */
    @JvmName("xtbxyqtoqyfsqcws")
    public suspend fun diskSizeGB(`value`: Output<Int>) {
        this.diskSizeGB = value
    }

    /**
     * @param value The lun is used to uniquely identify each data disk. If attaching multiple disks, each should have a distinct lun. The value must be between 0 and 63, inclusive.
     */
    @JvmName("dfdimybaqivuyphx")
    public suspend fun lun(`value`: Output<Int>) {
        this.lun = value
    }

    /**
     * @param value If omitted, the default is "Standard_LRS". Values are:
     *  Standard_LRS - The data disk should use standard locally redundant storage.
     *  Premium_LRS - The data disk should use premium locally redundant storage.
     */
    @JvmName("hhntaxsckapujnyh")
    public suspend fun storageAccountType(`value`: Output<StorageAccountType>) {
        this.storageAccountType = value
    }

    /**
     * @param value Values are:
     *  none - The caching mode for the disk is not enabled.
     *  readOnly - The caching mode for the disk is read only.
     *  readWrite - The caching mode for the disk is read and write.
     *  The default value for caching is none. For information about the caching options see: https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/.
     */
    @JvmName("uvldkcdeyecgpoia")
    public suspend fun caching(`value`: CachingType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.caching = mapped
    }

    /**
     * @param value
     */
    @JvmName("pwnfkhjxdeoukror")
    public suspend fun diskSizeGB(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskSizeGB = mapped
    }

    /**
     * @param value The lun is used to uniquely identify each data disk. If attaching multiple disks, each should have a distinct lun. The value must be between 0 and 63, inclusive.
     */
    @JvmName("cfevydklmydledtf")
    public suspend fun lun(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lun = mapped
    }

    /**
     * @param value If omitted, the default is "Standard_LRS". Values are:
     *  Standard_LRS - The data disk should use standard locally redundant storage.
     *  Premium_LRS - The data disk should use premium locally redundant storage.
     */
    @JvmName("bvwfcdoiquarpfpx")
    public suspend fun storageAccountType(`value`: StorageAccountType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountType = mapped
    }

    internal fun build(): DataDiskArgs = DataDiskArgs(
        caching = caching,
        diskSizeGB = diskSizeGB ?: throw PulumiNullFieldException("diskSizeGB"),
        lun = lun ?: throw PulumiNullFieldException("lun"),
        storageAccountType = storageAccountType,
    )
}
