@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.DeploymentConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property cloudServiceConfiguration This property and virtualMachineConfiguration are mutually exclusive and one of the properties must be specified. This property cannot be specified if the Batch account was created with its poolAllocationMode property set to 'UserSubscription'.
 * @property virtualMachineConfiguration This property and cloudServiceConfiguration are mutually exclusive and one of the properties must be specified.
 */
public data class DeploymentConfigurationArgs(
    public val cloudServiceConfiguration: Output<CloudServiceConfigurationArgs>? = null,
    public val virtualMachineConfiguration: Output<VirtualMachineConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.DeploymentConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.DeploymentConfigurationArgs =
        com.pulumi.azurenative.batch.inputs.DeploymentConfigurationArgs.builder()
            .cloudServiceConfiguration(
                cloudServiceConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .virtualMachineConfiguration(
                virtualMachineConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DeploymentConfigurationArgs].
 */
@PulumiTagMarker
public class DeploymentConfigurationArgsBuilder internal constructor() {
    private var cloudServiceConfiguration: Output<CloudServiceConfigurationArgs>? = null

    private var virtualMachineConfiguration: Output<VirtualMachineConfigurationArgs>? = null

    /**
     * @param value This property and virtualMachineConfiguration are mutually exclusive and one of the properties must be specified. This property cannot be specified if the Batch account was created with its poolAllocationMode property set to 'UserSubscription'.
     */
    @JvmName("aaschvjifdycnhhy")
    public suspend fun cloudServiceConfiguration(`value`: Output<CloudServiceConfigurationArgs>) {
        this.cloudServiceConfiguration = value
    }

    /**
     * @param value This property and cloudServiceConfiguration are mutually exclusive and one of the properties must be specified.
     */
    @JvmName("fosjknsyqamdvxnj")
    public suspend fun virtualMachineConfiguration(`value`: Output<VirtualMachineConfigurationArgs>) {
        this.virtualMachineConfiguration = value
    }

    /**
     * @param value This property and virtualMachineConfiguration are mutually exclusive and one of the properties must be specified. This property cannot be specified if the Batch account was created with its poolAllocationMode property set to 'UserSubscription'.
     */
    @JvmName("gxsnlskxtulolbiu")
    public suspend fun cloudServiceConfiguration(`value`: CloudServiceConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudServiceConfiguration = mapped
    }

    /**
     * @param argument This property and virtualMachineConfiguration are mutually exclusive and one of the properties must be specified. This property cannot be specified if the Batch account was created with its poolAllocationMode property set to 'UserSubscription'.
     */
    @JvmName("urkpwxrrwsdcwcfy")
    public suspend
    fun cloudServiceConfiguration(argument: suspend CloudServiceConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = CloudServiceConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cloudServiceConfiguration = mapped
    }

    /**
     * @param value This property and cloudServiceConfiguration are mutually exclusive and one of the properties must be specified.
     */
    @JvmName("wwxirgtacfnyrhsu")
    public suspend fun virtualMachineConfiguration(`value`: VirtualMachineConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualMachineConfiguration = mapped
    }

    /**
     * @param argument This property and cloudServiceConfiguration are mutually exclusive and one of the properties must be specified.
     */
    @JvmName("qrxalocdkwigouwl")
    public suspend
    fun virtualMachineConfiguration(argument: suspend VirtualMachineConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachineConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.virtualMachineConfiguration = mapped
    }

    internal fun build(): DeploymentConfigurationArgs = DeploymentConfigurationArgs(
        cloudServiceConfiguration = cloudServiceConfiguration,
        virtualMachineConfiguration = virtualMachineConfiguration,
    )
}
