@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.DiskEncryptionConfigurationArgs.builder
import com.pulumi.azurenative.batch.kotlin.enums.DiskEncryptionTarget
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The disk encryption configuration applied on compute nodes in the pool. Disk encryption configuration is not supported on Linux pool created with Virtual Machine Image or Shared Image Gallery Image.
 * @property targets On Linux pool, only "TemporaryDisk" is supported; on Windows pool, "OsDisk" and "TemporaryDisk" must be specified.
 */
public data class DiskEncryptionConfigurationArgs(
    public val targets: Output<List<DiskEncryptionTarget>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.DiskEncryptionConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.DiskEncryptionConfigurationArgs =
        com.pulumi.azurenative.batch.inputs.DiskEncryptionConfigurationArgs.builder()
            .targets(
                targets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [DiskEncryptionConfigurationArgs].
 */
@PulumiTagMarker
public class DiskEncryptionConfigurationArgsBuilder internal constructor() {
    private var targets: Output<List<DiskEncryptionTarget>>? = null

    /**
     * @param value On Linux pool, only "TemporaryDisk" is supported; on Windows pool, "OsDisk" and "TemporaryDisk" must be specified.
     */
    @JvmName("eekgpnbyfymirigg")
    public suspend fun targets(`value`: Output<List<DiskEncryptionTarget>>) {
        this.targets = value
    }

    @JvmName("slfmkoqnbxvhakyk")
    public suspend fun targets(vararg values: Output<DiskEncryptionTarget>) {
        this.targets = Output.all(values.asList())
    }

    /**
     * @param values On Linux pool, only "TemporaryDisk" is supported; on Windows pool, "OsDisk" and "TemporaryDisk" must be specified.
     */
    @JvmName("xvejhxwrhdgoqujo")
    public suspend fun targets(values: List<Output<DiskEncryptionTarget>>) {
        this.targets = Output.all(values)
    }

    /**
     * @param value On Linux pool, only "TemporaryDisk" is supported; on Windows pool, "OsDisk" and "TemporaryDisk" must be specified.
     */
    @JvmName("qkjpimmukejfiprn")
    public suspend fun targets(`value`: List<DiskEncryptionTarget>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targets = mapped
    }

    /**
     * @param values On Linux pool, only "TemporaryDisk" is supported; on Windows pool, "OsDisk" and "TemporaryDisk" must be specified.
     */
    @JvmName("jxllgcudbwvlkyvm")
    public suspend fun targets(vararg values: DiskEncryptionTarget) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targets = mapped
    }

    internal fun build(): DiskEncryptionConfigurationArgs = DiskEncryptionConfigurationArgs(
        targets = targets,
    )
}
