@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.EnvironmentSettingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name
 * @property value
 */
public data class EnvironmentSettingArgs(
    public val name: Output<String>,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.EnvironmentSettingArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.EnvironmentSettingArgs =
        com.pulumi.azurenative.batch.inputs.EnvironmentSettingArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EnvironmentSettingArgs].
 */
@PulumiTagMarker
public class EnvironmentSettingArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("fkdpdkydqyeoryts")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("dweprpvlyjguhtme")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value
     */
    @JvmName("yspvciagoshniyke")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("iwxnbcitchcludpp")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): EnvironmentSettingArgs = EnvironmentSettingArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        `value` = `value`,
    )
}
