@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.GetApplicationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the Batch account.
 * @property applicationName The name of the application. This must be unique within the account.
 * @property resourceGroupName The name of the resource group that contains the Batch account.
 */
public data class GetApplicationPlainArgs(
    public val accountName: String,
    public val applicationName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.GetApplicationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.GetApplicationPlainArgs =
        com.pulumi.azurenative.batch.inputs.GetApplicationPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .applicationName(applicationName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetApplicationPlainArgs].
 */
@PulumiTagMarker
public class GetApplicationPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var applicationName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Batch account.
     */
    @JvmName("dycotrkrijcutdnx")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the application. This must be unique within the account.
     */
    @JvmName("ayqtyvplcsjrhhor")
    public suspend fun applicationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.applicationName = mapped
    }

    /**
     * @param value The name of the resource group that contains the Batch account.
     */
    @JvmName("sqjdxasaqbjykfhi")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetApplicationPlainArgs = GetApplicationPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        applicationName = applicationName ?: throw PulumiNullFieldException("applicationName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
