@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.KeyVaultReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Identifies the Azure key vault associated with a Batch account.
 * @property id The resource ID of the Azure key vault associated with the Batch account.
 * @property url The URL of the Azure key vault associated with the Batch account.
 */
public data class KeyVaultReferenceArgs(
    public val id: Output<String>,
    public val url: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.KeyVaultReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.KeyVaultReferenceArgs =
        com.pulumi.azurenative.batch.inputs.KeyVaultReferenceArgs.builder()
            .id(id.applyValue({ args0 -> args0 }))
            .url(url.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyVaultReferenceArgs].
 */
@PulumiTagMarker
public class KeyVaultReferenceArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var url: Output<String>? = null

    /**
     * @param value The resource ID of the Azure key vault associated with the Batch account.
     */
    @JvmName("vudvwaxwekfikwug")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The URL of the Azure key vault associated with the Batch account.
     */
    @JvmName("qmpbyvafsrturqys")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value The resource ID of the Azure key vault associated with the Batch account.
     */
    @JvmName("gbsdvferllkgsghq")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The URL of the Azure key vault associated with the Batch account.
     */
    @JvmName("fhhiakcbbsuojyjp")
    public suspend fun url(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.url = mapped
    }

    internal fun build(): KeyVaultReferenceArgs = KeyVaultReferenceArgs(
        id = id ?: throw PulumiNullFieldException("id"),
        url = url ?: throw PulumiNullFieldException("url"),
    )
}
