@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.NetworkSecurityGroupRuleArgs.builder
import com.pulumi.azurenative.batch.kotlin.enums.NetworkSecurityGroupRuleAccess
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property access
 * @property priority Priorities within a pool must be unique and are evaluated in order of priority. The lower the number the higher the priority. For example, rules could be specified with order numbers of 150, 250, and 350. The rule with the order number of 150 takes precedence over the rule that has an order of 250. Allowed priorities are 150 to 4096. If any reserved or duplicate values are provided the request fails with HTTP status code 400.
 * @property sourceAddressPrefix Valid values are a single IP address (i.e. 10.10.10.10), IP subnet (i.e. 192.168.1.0/24), default tag, or * (for all addresses).  If any other values are provided the request fails with HTTP status code 400.
 * @property sourcePortRanges Valid values are '*' (for all ports 0 - 65535) or arrays of ports or port ranges (i.e. 100-200). The ports should in the range of 0 to 65535 and the port ranges or ports can't overlap. If any other values are provided the request fails with HTTP status code 400. Default value will be *.
 */
public data class NetworkSecurityGroupRuleArgs(
    public val access: Output<NetworkSecurityGroupRuleAccess>,
    public val priority: Output<Int>,
    public val sourceAddressPrefix: Output<String>,
    public val sourcePortRanges: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.NetworkSecurityGroupRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.NetworkSecurityGroupRuleArgs =
        com.pulumi.azurenative.batch.inputs.NetworkSecurityGroupRuleArgs.builder()
            .access(access.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .priority(priority.applyValue({ args0 -> args0 }))
            .sourceAddressPrefix(sourceAddressPrefix.applyValue({ args0 -> args0 }))
            .sourcePortRanges(sourcePortRanges?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [NetworkSecurityGroupRuleArgs].
 */
@PulumiTagMarker
public class NetworkSecurityGroupRuleArgsBuilder internal constructor() {
    private var access: Output<NetworkSecurityGroupRuleAccess>? = null

    private var priority: Output<Int>? = null

    private var sourceAddressPrefix: Output<String>? = null

    private var sourcePortRanges: Output<List<String>>? = null

    /**
     * @param value
     */
    @JvmName("ehlyuosirlrdirim")
    public suspend fun access(`value`: Output<NetworkSecurityGroupRuleAccess>) {
        this.access = value
    }

    /**
     * @param value Priorities within a pool must be unique and are evaluated in order of priority. The lower the number the higher the priority. For example, rules could be specified with order numbers of 150, 250, and 350. The rule with the order number of 150 takes precedence over the rule that has an order of 250. Allowed priorities are 150 to 4096. If any reserved or duplicate values are provided the request fails with HTTP status code 400.
     */
    @JvmName("jjhaoebqbpprudgh")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value Valid values are a single IP address (i.e. 10.10.10.10), IP subnet (i.e. 192.168.1.0/24), default tag, or * (for all addresses).  If any other values are provided the request fails with HTTP status code 400.
     */
    @JvmName("horrwlddlbqkajvg")
    public suspend fun sourceAddressPrefix(`value`: Output<String>) {
        this.sourceAddressPrefix = value
    }

    /**
     * @param value Valid values are '*' (for all ports 0 - 65535) or arrays of ports or port ranges (i.e. 100-200). The ports should in the range of 0 to 65535 and the port ranges or ports can't overlap. If any other values are provided the request fails with HTTP status code 400. Default value will be *.
     */
    @JvmName("nhrtadhlmlqmljxu")
    public suspend fun sourcePortRanges(`value`: Output<List<String>>) {
        this.sourcePortRanges = value
    }

    @JvmName("pawsderjhkielcal")
    public suspend fun sourcePortRanges(vararg values: Output<String>) {
        this.sourcePortRanges = Output.all(values.asList())
    }

    /**
     * @param values Valid values are '*' (for all ports 0 - 65535) or arrays of ports or port ranges (i.e. 100-200). The ports should in the range of 0 to 65535 and the port ranges or ports can't overlap. If any other values are provided the request fails with HTTP status code 400. Default value will be *.
     */
    @JvmName("qpihhxqntrlvfpij")
    public suspend fun sourcePortRanges(values: List<Output<String>>) {
        this.sourcePortRanges = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("qjiryavmytcygqhw")
    public suspend fun access(`value`: NetworkSecurityGroupRuleAccess) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.access = mapped
    }

    /**
     * @param value Priorities within a pool must be unique and are evaluated in order of priority. The lower the number the higher the priority. For example, rules could be specified with order numbers of 150, 250, and 350. The rule with the order number of 150 takes precedence over the rule that has an order of 250. Allowed priorities are 150 to 4096. If any reserved or duplicate values are provided the request fails with HTTP status code 400.
     */
    @JvmName("kyfwfpdssiqobkga")
    public suspend fun priority(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value Valid values are a single IP address (i.e. 10.10.10.10), IP subnet (i.e. 192.168.1.0/24), default tag, or * (for all addresses).  If any other values are provided the request fails with HTTP status code 400.
     */
    @JvmName("dqdjjiimvrlndecv")
    public suspend fun sourceAddressPrefix(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceAddressPrefix = mapped
    }

    /**
     * @param value Valid values are '*' (for all ports 0 - 65535) or arrays of ports or port ranges (i.e. 100-200). The ports should in the range of 0 to 65535 and the port ranges or ports can't overlap. If any other values are provided the request fails with HTTP status code 400. Default value will be *.
     */
    @JvmName("yxibadmkuytodxdb")
    public suspend fun sourcePortRanges(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourcePortRanges = mapped
    }

    /**
     * @param values Valid values are '*' (for all ports 0 - 65535) or arrays of ports or port ranges (i.e. 100-200). The ports should in the range of 0 to 65535 and the port ranges or ports can't overlap. If any other values are provided the request fails with HTTP status code 400. Default value will be *.
     */
    @JvmName("bcwdurnigaqaxxjy")
    public suspend fun sourcePortRanges(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourcePortRanges = mapped
    }

    internal fun build(): NetworkSecurityGroupRuleArgs = NetworkSecurityGroupRuleArgs(
        access = access ?: throw PulumiNullFieldException("access"),
        priority = priority ?: throw PulumiNullFieldException("priority"),
        sourceAddressPrefix = sourceAddressPrefix ?: throw PulumiNullFieldException("sourceAddressPrefix"),
        sourcePortRanges = sourcePortRanges,
    )
}
