@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.UserAccountArgs.builder
import com.pulumi.azurenative.batch.kotlin.enums.ElevationLevel
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property elevationLevel nonAdmin - The auto user is a standard user without elevated access. admin - The auto user is a user with elevated access and operates with full Administrator permissions. The default value is nonAdmin.
 * @property linuxUserConfiguration This property is ignored if specified on a Windows pool. If not specified, the user is created with the default options.
 * @property name
 * @property password
 * @property windowsUserConfiguration This property can only be specified if the user is on a Windows pool. If not specified and on a Windows pool, the user is created with the default options.
 */
public data class UserAccountArgs(
    public val elevationLevel: Output<ElevationLevel>? = null,
    public val linuxUserConfiguration: Output<LinuxUserConfigurationArgs>? = null,
    public val name: Output<String>,
    public val password: Output<String>,
    public val windowsUserConfiguration: Output<WindowsUserConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.UserAccountArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.UserAccountArgs =
        com.pulumi.azurenative.batch.inputs.UserAccountArgs.builder()
            .elevationLevel(elevationLevel?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .linuxUserConfiguration(
                linuxUserConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name.applyValue({ args0 -> args0 }))
            .password(password.applyValue({ args0 -> args0 }))
            .windowsUserConfiguration(
                windowsUserConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [UserAccountArgs].
 */
@PulumiTagMarker
public class UserAccountArgsBuilder internal constructor() {
    private var elevationLevel: Output<ElevationLevel>? = null

    private var linuxUserConfiguration: Output<LinuxUserConfigurationArgs>? = null

    private var name: Output<String>? = null

    private var password: Output<String>? = null

    private var windowsUserConfiguration: Output<WindowsUserConfigurationArgs>? = null

    /**
     * @param value nonAdmin - The auto user is a standard user without elevated access. admin - The auto user is a user with elevated access and operates with full Administrator permissions. The default value is nonAdmin.
     */
    @JvmName("eknrxqbuuclqmcab")
    public suspend fun elevationLevel(`value`: Output<ElevationLevel>) {
        this.elevationLevel = value
    }

    /**
     * @param value This property is ignored if specified on a Windows pool. If not specified, the user is created with the default options.
     */
    @JvmName("dipwiecnlxutvsbo")
    public suspend fun linuxUserConfiguration(`value`: Output<LinuxUserConfigurationArgs>) {
        this.linuxUserConfiguration = value
    }

    /**
     * @param value
     */
    @JvmName("jltpelimvgyphigk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("cqtojwpebnaeeauy")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value This property can only be specified if the user is on a Windows pool. If not specified and on a Windows pool, the user is created with the default options.
     */
    @JvmName("olrcsjmidberhtyk")
    public suspend fun windowsUserConfiguration(`value`: Output<WindowsUserConfigurationArgs>) {
        this.windowsUserConfiguration = value
    }

    /**
     * @param value nonAdmin - The auto user is a standard user without elevated access. admin - The auto user is a user with elevated access and operates with full Administrator permissions. The default value is nonAdmin.
     */
    @JvmName("isirjrwbavmvttdx")
    public suspend fun elevationLevel(`value`: ElevationLevel?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elevationLevel = mapped
    }

    /**
     * @param value This property is ignored if specified on a Windows pool. If not specified, the user is created with the default options.
     */
    @JvmName("vogyuojbcabnxkfm")
    public suspend fun linuxUserConfiguration(`value`: LinuxUserConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linuxUserConfiguration = mapped
    }

    /**
     * @param argument This property is ignored if specified on a Windows pool. If not specified, the user is created with the default options.
     */
    @JvmName("imkqsjeoyhtqjail")
    public suspend
    fun linuxUserConfiguration(argument: suspend LinuxUserConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = LinuxUserConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linuxUserConfiguration = mapped
    }

    /**
     * @param value
     */
    @JvmName("ictmnejaxqqkqqda")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("oyoshtvgoemmvkuj")
    public suspend fun password(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value This property can only be specified if the user is on a Windows pool. If not specified and on a Windows pool, the user is created with the default options.
     */
    @JvmName("fkwwlatabcxwvswq")
    public suspend fun windowsUserConfiguration(`value`: WindowsUserConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.windowsUserConfiguration = mapped
    }

    /**
     * @param argument This property can only be specified if the user is on a Windows pool. If not specified and on a Windows pool, the user is created with the default options.
     */
    @JvmName("ppceqpjjmufcftrv")
    public suspend
    fun windowsUserConfiguration(argument: suspend WindowsUserConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = WindowsUserConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.windowsUserConfiguration = mapped
    }

    internal fun build(): UserAccountArgs = UserAccountArgs(
        elevationLevel = elevationLevel,
        linuxUserConfiguration = linuxUserConfiguration,
        name = name ?: throw PulumiNullFieldException("name"),
        password = password ?: throw PulumiNullFieldException("password"),
        windowsUserConfiguration = windowsUserConfiguration,
    )
}
