@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.WindowsUserConfigurationArgs.builder
import com.pulumi.azurenative.batch.kotlin.enums.LoginMode
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property loginMode Specifies login mode for the user. The default value for VirtualMachineConfiguration pools is interactive mode and for CloudServiceConfiguration pools is batch mode.
 */
public data class WindowsUserConfigurationArgs(
    public val loginMode: Output<LoginMode>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.WindowsUserConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.WindowsUserConfigurationArgs =
        com.pulumi.azurenative.batch.inputs.WindowsUserConfigurationArgs.builder()
            .loginMode(loginMode?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [WindowsUserConfigurationArgs].
 */
@PulumiTagMarker
public class WindowsUserConfigurationArgsBuilder internal constructor() {
    private var loginMode: Output<LoginMode>? = null

    /**
     * @param value Specifies login mode for the user. The default value for VirtualMachineConfiguration pools is interactive mode and for CloudServiceConfiguration pools is batch mode.
     */
    @JvmName("qmovphfennpigdcx")
    public suspend fun loginMode(`value`: Output<LoginMode>) {
        this.loginMode = value
    }

    /**
     * @param value Specifies login mode for the user. The default value for VirtualMachineConfiguration pools is interactive mode and for CloudServiceConfiguration pools is batch mode.
     */
    @JvmName("xuopjtjoyvfdpicl")
    public suspend fun loginMode(`value`: LoginMode?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loginMode = mapped
    }

    internal fun build(): WindowsUserConfigurationArgs = WindowsUserConfigurationArgs(
        loginMode = loginMode,
    )
}
