@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property evaluationInterval If omitted, the default value is 15 minutes (PT15M).
 * @property formula
 */
public data class AutoScaleSettingsResponse(
    public val evaluationInterval: String? = null,
    public val formula: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.AutoScaleSettingsResponse):
            AutoScaleSettingsResponse = AutoScaleSettingsResponse(
            evaluationInterval = javaType.evaluationInterval().map({ args0 -> args0 }).orElse(null),
            formula = javaType.formula(),
        )
    }
}
